/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Set;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.core.ManifestParser;
import org.openhab.tools.analysis.checkstyle.api.AbstractStaticCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportExportedPackagesCheck
extends AbstractStaticCheck {
    private static final String NOT_IMPORTED_PACKAGE_MESSAGE = "The exported package `{0}` is not imported";
    private final Logger logger = LoggerFactory.getLogger(ImportExportedPackagesCheck.class);

    public ImportExportedPackagesCheck() {
        this.setFileExtensions(new String[]{"MF"});
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        try {
            Set exports = ManifestParser.parseManifest((File)file).getExports();
            Set imports = ManifestParser.parseManifest((File)file).getImports();
            if (!exports.isEmpty()) {
                int lineToLog = this.findLineNumberSafe(fileText, "Export-Package", 0, "Export-Package header line number not found.");
                for (ExportPackage export : exports) {
                    if (this.isPackageImported(imports, export)) continue;
                    this.log(lineToLog, MessageFormat.format(NOT_IMPORTED_PACKAGE_MESSAGE, export.toString()), new Object[0]);
                }
            }
        }
        catch (IOException e) {
            this.logger.error("An error occured while processing the file {}", (Object)file.getPath(), (Object)e);
        }
        catch (ParseException e) {
            this.logger.error("An error occured while trying to parse the MANIFEST: {}", (Object)file.getPath(), (Object)e);
        }
    }

    private boolean isPackageImported(Set<BundleRequirement> imports, ExportPackage searchedPackage) {
        for (BundleRequirement o : imports) {
            if (!o.toString().equals(searchedPackage.toString())) continue;
            return true;
        }
        return false;
    }
}

