/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.ivy.osgi.core.BundleInfo;
import org.openhab.tools.analysis.checkstyle.api.AbstractExternalLibrariesCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestExternalLibrariesCheck
extends AbstractExternalLibrariesCheck {
    private static final String COULD_NOT_OPEN_MANIFEST = "Could not open MANIFEST.MF";
    private static final String FILES_NEED_TO_BE_IN_A_LIB_FOLDER = "All jar files need to be placed inside a lib folder.";
    private static final String JAR_NOT_PRESENT_IN_LIB_FOLDER = "The jar file %s is not present in the lib folder";
    private static final String JAR_PRESENT_IN_LIB_NOT_IN_MANIFEST = "The jar file %s is present in the lib folder but is not present in the MANIFEST.MF file";
    private final Logger logger = LoggerFactory.getLogger(ManifestExternalLibrariesCheck.class);

    public ManifestExternalLibrariesCheck() {
        this.setFileExtensions(new String[]{"MF"});
    }

    private List<String> getManifestJarFiles(FileText fileText) throws IOException {
        BundleInfo manifest = null;
        try {
            manifest = this.parseManifestFromFile(fileText);
        }
        catch (CheckstyleException ex) {
            throw new IOException(COULD_NOT_OPEN_MANIFEST);
        }
        List classpathEntries = manifest.getClasspath();
        if (classpathEntries != null) {
            classpathEntries.replaceAll(String::trim);
            classpathEntries.removeIf(x -> !x.contains(".jar"));
            return classpathEntries;
        }
        return Collections.emptyList();
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        if (!file.getName().equals("MANIFEST.MF")) {
            return;
        }
        String rootFolderPath = file.getParentFile().getParentFile().getAbsolutePath();
        String buildPropertiesPath = String.valueOf(rootFolderPath) + File.separator + "build.properties";
        String libFolderPath = String.valueOf(rootFolderPath) + File.separator + "lib";
        List<Object> manifestJarFiles = Collections.emptyList();
        try {
            manifestJarFiles = this.getManifestJarFiles(fileText);
        }
        catch (IOException e) {
            this.logger.error(COULD_NOT_OPEN_MANIFEST);
            return;
        }
        File lib = new File(libFolderPath);
        if (!lib.exists() || !lib.isDirectory()) {
            if (manifestJarFiles.isEmpty()) {
                return;
            }
            this.log(0, FILES_NEED_TO_BE_IN_A_LIB_FOLDER, new Object[0]);
            return;
        }
        List<String> libJarFiles = this.getLibFolderJarFiles(lib, buildPropertiesPath);
        this.checkFiles(manifestJarFiles, libJarFiles, JAR_NOT_PRESENT_IN_LIB_FOLDER);
        this.checkFiles(libJarFiles, manifestJarFiles, JAR_PRESENT_IN_LIB_NOT_IN_MANIFEST);
    }
}

