/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.openhab.tools.analysis.checkstyle.api.AbstractStaticCheck;

public class ManifestLineLengthCheck
extends AbstractStaticCheck {
    private static final int MAX_LINE_SIZE = 72;
    private static final String LOG_MESSAGE = "No line may be longer than 72 bytes (not characters), in its UTF8-encoded form. If a value would make the initial line longer than this, it should be continued on extra lines (each starting with a single SPACE).";

    public ManifestLineLengthCheck() {
        this.setFileExtensions(new String[]{"MF"});
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        if (Arrays.stream(fileText.toLinesArray()).anyMatch(x -> x.getBytes(StandardCharsets.UTF_8).length > 72)) {
            this.log(0, LOG_MESSAGE, new Object[0]);
        }
    }
}

