/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExportPackage;
import org.openhab.tools.analysis.checkstyle.api.AbstractStaticCheck;

public class ManifestPackageVersionCheck
extends AbstractStaticCheck {
    private static final String VERSION_USED_MSG = "The version of the package %s should not be specified";
    private static final String PACKAGE_PATTERN = "[a-zA-Z0-9\\._-]*";
    private List<String> ignoreImportedPackages;
    private List<String> ignoreExportedPackages;

    public ManifestPackageVersionCheck() {
        this.setFileExtensions(new String[]{"MF"});
    }

    public void setIgnoreImportedPackages(String[] ignoreImportedPackages) {
        this.ignoreImportedPackages = Arrays.asList(ignoreImportedPackages);
    }

    public void setIgnoreExportedPackages(String[] ignoreExportedPackages) {
        this.ignoreExportedPackages = Arrays.asList(ignoreExportedPackages);
    }

    protected void processFiltered(File manifestFile, FileText fileText) throws CheckstyleException {
        BundleInfo manifest = this.parseManifestFromFile(fileText);
        this.checkVersionOfImportedPackages(manifest, fileText);
        this.checkVersionOfExportedPackages(manifest, fileText);
    }

    private void checkVersionOfImportedPackages(BundleInfo manifest, FileText fileText) {
        Set requiredBundles = manifest.getRequires();
        Set importPackages = manifest.getImports();
        int lineNumber = 0;
        for (BundleRequirement importPackage : importPackages) {
            String importName = importPackage.getName();
            if (importPackage.getVersion() == null || this.isIgnoredPackage(this.ignoreImportedPackages, importName)) continue;
            lineNumber = this.findLineNumberSafe(fileText, importName, lineNumber, "Imported package line number not found.");
            this.log(lineNumber, String.format(VERSION_USED_MSG, importName), new Object[0]);
        }
        lineNumber = 0;
        for (BundleRequirement requiredBundle : requiredBundles) {
            if (requiredBundle.getVersion() == null) continue;
            String name = requiredBundle.getName();
            lineNumber = this.findLineNumberSafe(fileText, name, lineNumber, "Required bundle line number not found.");
            this.log(lineNumber, String.format(VERSION_USED_MSG, name), new Object[0]);
        }
    }

    private void checkVersionOfExportedPackages(BundleInfo manifest, FileText fileText) {
        Set exports = manifest.getExports();
        int lineNumber = 0;
        for (ExportPackage exportPackage : exports) {
            String exportedPackageName = exportPackage.getName();
            if (exportPackage.getVersion().equals((Object)BundleInfo.DEFAULT_VERSION) || this.isIgnoredPackage(this.ignoreExportedPackages, exportedPackageName)) continue;
            lineNumber = this.findLineNumberSafe(fileText, exportedPackageName, lineNumber, "Exported package line number not found.");
            this.log(lineNumber, String.format(VERSION_USED_MSG, exportedPackageName), new Object[0]);
        }
    }

    private boolean isIgnoredPackage(List<String> ignoredPackages, String packageName) {
        for (String packages : ignoredPackages) {
            Pattern pattern = Pattern.compile(packages = packages.replaceAll("\\.\\*", PACKAGE_PATTERN));
            Matcher matcher = pattern.matcher(packageName);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }
}

