/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openhab.tools.analysis.checkstyle.api.AbstractOhInfXmlCheck;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OhInfXmlLabelCheck
extends AbstractOhInfXmlCheck {
    private static final String CONFIG_ATTR_KEY = "name";
    private static final String THING_ATTR_KEY = "id";
    private static final String I18N_PREFIX = "@text/";
    private static final String PARAMETER_LABEL_EXPRESSION = "//parameter/label/text()";
    private static final String PARAMETER_GROUP_LABEL_EXPRESSION = "//parameter-group/label/text()";
    private static final String CHANNEL_LABEL_EXPRESSION = "//channel/label/text()";
    private static final String CHANNEL_GROUP_LABEL_EXPRESSION = "//channel-group/label/text()";
    private static final String CHANNEL_TYPE_LABEL_EXPRESSION = "//channel-type/label/text()";
    private static final String CHANNEL_GROUP_TYPE_LABEL_EXPRESSION = "//channel-group-type/label/text()";
    private static final String THING_TYPE_LABEL_EXPRESSION = "//thing-type/label/text()";
    private static final Pattern SKIP_PATTERN = Pattern.compile("[A-Z\\d+\\.\\(\\)]");
    private static final List<String> ALL_CONFIG_EXPRESSIONS = Arrays.asList("//parameter/label/text()", "//parameter-group/label/text()");
    private static final List<String> ALL_THING_EXPRESSIONS = Arrays.asList("//thing-type/label/text()", "//channel/label/text()", "//channel-group/label/text()", "//channel-type/label/text()", "//channel-group-type/label/text()");
    private static final List<String> ALL_THING_CONFIG_EXPRESSIONS = Collections.singletonList("//parameter/label/text()");
    private static final Pattern TYPE_PATTERN = Pattern.compile("//([^\\/]+)");
    private static final Pattern LABEL_PATTERN = Pattern.compile("<label>([^<]+)</label>");
    public static final String MESSAGE_LABEL_UPPERCASE = "Label of {0} with {1} ''''{2}'''' does not have uppercase first character for each word: ''''{3}''''";
    public static final String MESSAGE_MAX_LABEL_LENGTH = "Label of {0} with {1} ''''{2}'''' exceeds maximum length of %d characters with length {4}: ''''{3}''''";
    public static final Set<String> LOWER_CASE_WORDS = Stream.of("a", "an", "the", "and", "as", "but", "by", "for", "from", "in", "into", "like", "near", "nor", "of", "onto", "or", "out", "over", "past", "so", "till", "to", "up", "upon", "with", "yet").collect(Collectors.toSet());
    private int maxLabelLength = Integer.MAX_VALUE;
    private int maxLabelLengthError = Integer.MAX_VALUE;
    private boolean doCheckWordCasing;
    private String dynamicMessageMaxLabelLength = "";
    private String dynamicMessageMaxLabelLengthError = "";

    public void setMaxLabelLength(String maxLabelLength) {
        this.maxLabelLength = maxLabelLength == null ? Integer.MAX_VALUE : Integer.parseInt(maxLabelLength);
        this.dynamicMessageMaxLabelLength = String.format(MESSAGE_MAX_LABEL_LENGTH, this.maxLabelLength);
    }

    public void setMaxLabelLengthError(String maxLabelLength) {
        this.maxLabelLengthError = maxLabelLength == null ? Integer.MAX_VALUE : Integer.parseInt(maxLabelLength);
        this.dynamicMessageMaxLabelLengthError = String.format(MESSAGE_MAX_LABEL_LENGTH, this.maxLabelLengthError);
    }

    public void setCheckWordCasing(String check) {
        this.doCheckWordCasing = Boolean.valueOf(check);
    }

    @Override
    protected void checkConfigFile(FileText xmlFileText) throws CheckstyleException {
        for (String expression : ALL_CONFIG_EXPRESSIONS) {
            this.evaluateExpressionOnFile(xmlFileText, expression, CONFIG_ATTR_KEY);
        }
    }

    @Override
    protected void checkBindingFile(FileText xmlFileText) throws CheckstyleException {
    }

    @Override
    protected void checkThingTypeFile(FileText xmlFileText) throws CheckstyleException {
        for (String expression : ALL_THING_EXPRESSIONS) {
            this.evaluateExpressionOnFile(xmlFileText, expression, THING_ATTR_KEY);
        }
        for (String expression : ALL_THING_CONFIG_EXPRESSIONS) {
            this.evaluateExpressionOnFile(xmlFileText, expression, CONFIG_ATTR_KEY);
        }
    }

    private void evaluateExpressionOnFile(FileText xmlFileText, String xPathExpression, String key) throws CheckstyleException {
        String type = this.fiterType(xPathExpression);
        HashMap<String, Integer> lineNumberMap = new HashMap<String, Integer>();
        NodeList nodes = this.getNodes(xmlFileText, xPathExpression);
        File file = xmlFileText.getFile();
        if (nodes != null) {
            int i = 0;
            while (i < nodes.getLength()) {
                String labelText = nodes.item(i).getNodeValue();
                if (this.noI18NLabel(labelText)) {
                    this.checkWordCasing(xmlFileText, lineNumberMap, key, type, nodes.item(i), file, labelText);
                    this.checkLabelLength(xmlFileText, lineNumberMap, key, type, nodes.item(i), file, labelText);
                }
                ++i;
            }
        }
    }

    private boolean noI18NLabel(String labelText) {
        return !labelText.startsWith(I18N_PREFIX);
    }

    private void checkWordCasing(FileText xmlFileText, Map<String, Integer> lineNumberMap, String key, String type, Node node, File file, String labelText) {
        if (!this.doCheckWordCasing) {
            return;
        }
        String[] words = labelText.split("\\s+");
        int i = 0;
        while (i < words.length) {
            String word = words[i];
            int firtCharType = Character.getType(word.charAt(0));
            boolean lowerCase = firtCharType == 2;
            boolean firstOrLastWord = i == 0 || i == words.length - 1;
            boolean log = false;
            if (lowerCase) {
                if (!(!firstOrLastWord && LOWER_CASE_WORDS.contains(word) || SKIP_PATTERN.matcher(word).find())) {
                    log = true;
                }
            } else if (!firstOrLastWord && LOWER_CASE_WORDS.contains(word) && firtCharType == 1) {
                log = true;
            }
            if (log) {
                this.log(xmlFileText, lineNumberMap, MESSAGE_LABEL_UPPERCASE, key, type, node, file, labelText);
                return;
            }
            ++i;
        }
    }

    private void checkLabelLength(FileText xmlFileText, Map<String, Integer> lineNumberMap, String key, String type, Node node, File file, String labelText) {
        if (labelText.length() > this.maxLabelLengthError) {
            SeverityLevel configuredSeverityLevel = this.getSeverityLevel();
            this.setSeverity(SeverityLevel.ERROR.name());
            this.log(xmlFileText, lineNumberMap, this.dynamicMessageMaxLabelLengthError, key, type, node, file, labelText);
            this.setSeverity(configuredSeverityLevel.name());
        } else if (labelText.length() > this.maxLabelLength) {
            this.log(xmlFileText, lineNumberMap, this.dynamicMessageMaxLabelLength, key, type, node, file, labelText);
        }
    }

    private void log(FileText xmlFileText, Map<String, Integer> lineNumberMap, String message, String key, String type, Node node, File file, String labelText) {
        this.lazyLoadMap(xmlFileText, lineNumberMap);
        Integer lineNr = lineNumberMap.get(labelText);
        this.logMessage(file.getPath(), lineNr == null ? 0 : lineNr, file.getName(), MessageFormat.format(message, type, key, this.getReferenceId(key, node), labelText, labelText.length()));
    }

    private void lazyLoadMap(FileText xmlFileText, Map<String, Integer> lineNumberMap) {
        if (lineNumberMap.isEmpty()) {
            String[] lines = xmlFileText.getFullText().toString().split(System.lineSeparator());
            int i = 0;
            while (i < lines.length) {
                Matcher matcher = LABEL_PATTERN.matcher(lines[i]);
                if (matcher.find()) {
                    lineNumberMap.put(matcher.group(1), i + 1);
                }
                ++i;
            }
        }
    }

    private String getReferenceId(String key, Node node) {
        return node.getParentNode().getParentNode().getAttributes().getNamedItem(key).getNodeValue();
    }

    private String fiterType(String expression) {
        Matcher matcher = TYPE_PATTERN.matcher(expression);
        return matcher.find() ? matcher.group(1) : "";
    }
}

