/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.openhab.tools.analysis.checkstyle.api.AbstractStaticCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceComponentManifestCheck
extends AbstractStaticCheck {
    private static final String WILDCARD = "*";
    private final Logger logger = LoggerFactory.getLogger(ServiceComponentManifestCheck.class);
    private List<String> manifestServiceComponents = new ArrayList<String>();
    private List<String> componentXmlFiles = new ArrayList<String>();
    private boolean loggedBestApproachMessage = false;
    private String serviceComponentHeaderValue;
    private int serviceComponentHeaderLineNumber;
    private String manifestPath;
    private String buildPropertiesPath;
    private List<Path> componentXmlRelativePaths = new ArrayList<Path>();
    private IBuild buildPropertiesFile;

    public ServiceComponentManifestCheck() {
        this.logger.debug("Executing {}: Check if all the declarative services are included in the {}", (Object)((Object)((Object)this)).getClass().getName(), (Object)"MANIFEST.MF");
        this.setFileExtensions(new String[]{"MF", "xml", "properties"});
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        Path absolutePath = file.toPath();
        int osgiInfIndex = this.getIndex(absolutePath, "OSGI-INF");
        String fileExtension = FilenameUtils.getExtension((String)file.getName());
        if (fileExtension.equals("xml") && osgiInfIndex > -1) {
            this.componentXmlFiles.add(file.getName());
            Path relativePath = absolutePath.subpath(osgiInfIndex, absolutePath.getNameCount());
            this.componentXmlRelativePaths.add(relativePath);
        }
        if (file.getName().equals("MANIFEST.MF")) {
            this.verifyManifest(fileText);
        }
        if (file.getName().equals("build.properties")) {
            this.processBuildPropertiesFile(fileText);
        }
    }

    private int getIndex(Path path, String dirName) {
        int result = -1;
        int i = 0;
        while (i < path.getNameCount()) {
            if (path.getName(i).toString().equals(dirName)) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    private void processBuildPropertiesFile(FileText fileText) {
        try {
            this.buildPropertiesFile = this.parseBuildProperties(fileText);
            this.buildPropertiesPath = fileText.getFile().getPath();
        }
        catch (CheckstyleException e) {
            this.logger.error("Problem occurred while parsing the file {}", (Object)this.buildPropertiesPath, (Object)e);
        }
    }

    public void finishProcessing() {
        this.verifyManifestWildcardDeclaredServiceComponents();
        this.verifyManifestExplicitlyDeclaredServices();
        this.verifyBuildPropertiesFile();
    }

    private void verifyBuildPropertiesFile() {
        if (this.buildPropertiesPath != null) {
            IBuildEntry binIncludes = this.buildPropertiesFile.getEntry("bin.includes");
            if (binIncludes != null) {
                String[] includedTokens;
                String[] stringArray = includedTokens = binIncludes.getTokens();
                int n = includedTokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String included = stringArray[n2];
                    Iterator<Path> iterator = this.componentXmlRelativePaths.iterator();
                    while (iterator.hasNext()) {
                        Path componentXmlFile = iterator.next();
                        if (!componentXmlFile.startsWith(included)) continue;
                        iterator.remove();
                    }
                    ++n2;
                }
            }
            for (Path path : this.componentXmlRelativePaths) {
                this.logMessage(this.buildPropertiesPath, 0, "build.properties", MessageFormat.format("The service component {0} isn`t included in the build.properties file. Good approach is to include all files by adding `OSGI-INF/` value to the bin.includes property.", path));
            }
        }
    }

    private void verifyManifestWildcardDeclaredServiceComponents() {
        Iterator<String> manifestServiceComponentsIterator = this.manifestServiceComponents.iterator();
        while (manifestServiceComponentsIterator.hasNext()) {
            String manifestServiceComponent = manifestServiceComponentsIterator.next();
            if (manifestServiceComponent.equals(WILDCARD)) {
                this.logBestApproachMessage();
                this.manifestServiceComponents.clear();
                this.componentXmlFiles.clear();
                break;
            }
            String manifestServiceComponentName = StringUtils.substringBefore((String)manifestServiceComponent, (String)".xml");
            if (manifestServiceComponentName.contains(WILDCARD)) {
                if (manifestServiceComponentName.equals(WILDCARD)) {
                    if (this.manifestServiceComponents.size() > 1) {
                        this.logMessage(this.serviceComponentHeaderLineNumber, "If you are using OSGI-INF/*.xml, do not include any of the services explicitly. Otherwise they will be included more than once.");
                    }
                    this.manifestServiceComponents.clear();
                    this.componentXmlFiles.clear();
                    break;
                }
                this.logBestApproachMessage();
                Pattern pattern = Pattern.compile(manifestServiceComponentName);
                boolean matchedPattern = false;
                Iterator<String> componentXmlFilesIterator = this.componentXmlFiles.iterator();
                while (componentXmlFilesIterator.hasNext()) {
                    String componentXml = componentXmlFilesIterator.next();
                    Matcher matcher = pattern.matcher(componentXml);
                    if (!matcher.find()) continue;
                    componentXmlFilesIterator.remove();
                    matchedPattern = true;
                }
                if (!matchedPattern) {
                    this.logMessage(this.serviceComponentHeaderLineNumber, String.format("The service component %s does not match any of the exisitng services.", manifestServiceComponent));
                }
                manifestServiceComponentsIterator.remove();
                continue;
            }
            this.logBestApproachMessage();
        }
    }

    private void verifyManifestExplicitlyDeclaredServices() {
        ArrayList<String> intersection = new ArrayList<String>(this.manifestServiceComponents);
        intersection.retainAll(this.componentXmlFiles);
        this.componentXmlFiles.removeAll(intersection);
        for (String service : this.componentXmlFiles) {
            this.logMessage(this.serviceComponentHeaderLineNumber, String.format("The service %s is not included in the MANIFEST.MF file. Are you sure that there is no need to be included?", service));
        }
        this.manifestServiceComponents.removeAll(intersection);
        for (String service : this.manifestServiceComponents) {
            this.logMessage(this.serviceComponentHeaderLineNumber, String.format("The service %s does not exist in the OSGI-INF folder.", service));
        }
    }

    private void verifyManifest(FileText fileText) {
        File file = fileText.getFile();
        this.manifestPath = file.getPath();
        try {
            Manifest manifest = new Manifest(new FileInputStream(file));
            Attributes attributes = manifest.getMainAttributes();
            this.serviceComponentHeaderValue = attributes.getValue("Service-Component");
            if (this.serviceComponentHeaderValue != null) {
                this.serviceComponentHeaderLineNumber = this.findLineNumberSafe(fileText, "Service-Component", 0, "Service component header line number not found.");
                List<String> serviceComponentsList = Arrays.asList(this.serviceComponentHeaderValue.trim().split(","));
                for (String serviceComponent : serviceComponentsList) {
                    String serviceComponentName;
                    File serviceComponentFile = new File(serviceComponent);
                    String serviceComponentParentDirectoryName = serviceComponentFile.getParentFile().getName();
                    if (!serviceComponentParentDirectoryName.equals("OSGI-INF")) {
                        this.logMessage(this.serviceComponentHeaderLineNumber, String.format("Incorrect directory for services - %s. The best practice is services metadata files to be placed directly in OSGI-INF directory.", serviceComponentParentDirectoryName));
                    }
                    if ((serviceComponentName = serviceComponentFile.getName()).endsWith("xml") || serviceComponentName.endsWith(WILDCARD)) {
                        this.manifestServiceComponents.add(serviceComponentName);
                        continue;
                    }
                    this.logMessage(this.serviceComponentHeaderLineNumber, String.format("The service %s is with invalid extension.Only XML metadata files for services description are expected in the OSGI-INF directory.", serviceComponentName));
                }
            }
        }
        catch (IOException e) {
            this.logger.error("Problem occurred while parsing the file {}", (Object)file.getPath(), (Object)e);
        }
    }

    private void logBestApproachMessage() {
        if (!this.loggedBestApproachMessage) {
            this.logMessage(this.serviceComponentHeaderLineNumber, "A good approach is to use OSGI-INF/*.xml instead of including the services metadata files separately or using common wildcard.");
            this.loggedBestApproachMessage = true;
        }
    }

    private void logMessage(int line, String message) {
        this.logMessage(this.manifestPath, line, "MANIFEST.MF", message);
    }
}

