/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.pde.core.build.IBuildEntry;
import org.openhab.tools.analysis.checkstyle.api.AbstractStaticCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExternalLibrariesCheck
extends AbstractStaticCheck {
    protected static final String LIB_FOLDER_NAME = "lib";
    protected static final String JAR_FILE_EXTENSION = ".jar";
    private static final String BIN_EXCLUDES = "bin.excludes";
    protected static final String COULD_NOT_OPEN_BUILD_PROPERTIES = "Could not open build properties";
    private final Logger logger = LoggerFactory.getLogger(AbstractExternalLibrariesCheck.class);

    protected List<String> getLibFolderJarFiles(File libDirectory, String buildPropertiesPath) {
        List<Object> excludedJarFiles = new ArrayList();
        try {
            excludedJarFiles = this.getExcludedJarFiles(buildPropertiesPath);
        }
        catch (IOException e) {
            this.logger.error(COULD_NOT_OPEN_BUILD_PROPERTIES);
        }
        File[] files = libDirectory.listFiles();
        ArrayList<String> libJarFiles = new ArrayList<String>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName;
            File file = fileArray[n2];
            if (!file.isDirectory() && file.getName().endsWith(JAR_FILE_EXTENSION) && !excludedJarFiles.contains(fileName = "lib/" + file.getName())) {
                libJarFiles.add(fileName);
            }
            ++n2;
        }
        return libJarFiles;
    }

    private List<String> getExcludedJarFiles(String buildPropertiesPath) throws IOException {
        File buildProperties = new File(buildPropertiesPath);
        FileText buildPropertiesFileText = new FileText(buildProperties, "UTF-8");
        IBuildEntry binExcludesEntry = null;
        try {
            binExcludesEntry = this.parseBuildProperties(buildPropertiesFileText).getEntry(BIN_EXCLUDES);
        }
        catch (CheckstyleException ex) {
            throw new IOException(COULD_NOT_OPEN_BUILD_PROPERTIES);
        }
        ArrayList<String> excludedJarFiles = new ArrayList<String>();
        if (binExcludesEntry != null) {
            String[] binExcludes = binExcludesEntry.getTokens();
            int i = 0;
            while (i < binExcludes.length) {
                if (binExcludes[i].endsWith(JAR_FILE_EXTENSION)) {
                    excludedJarFiles.add(binExcludes[i].trim());
                }
                ++i;
            }
        }
        return excludedJarFiles;
    }

    protected void checkFiles(List<String> jarFilesToCheck, List<String> jarFiles, String messageTemplate) {
        ArrayList<String> filesToCheck = new ArrayList<String>(jarFilesToCheck);
        filesToCheck.removeAll(jarFiles);
        filesToCheck.forEach(fileName -> this.log(0, String.format(messageTemplate, fileName), new Object[0]));
    }
}

