/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.openhab.tools.analysis.checkstyle.api.AbstractStaticCheck;

public class AbstractManifestAttributeCheck
extends AbstractStaticCheck {
    private final String attribute;
    private final String exampleValue;
    private final int maxOccurrences;
    private final String lowerCasePrefix;
    private final String requiredPrefix;
    private List<String> allowedValues;

    public AbstractManifestAttributeCheck(String attribute, String exampleValue, int maxOccurrences) {
        this.setFileExtensions(new String[]{"MF"});
        this.attribute = attribute;
        this.exampleValue = exampleValue;
        this.maxOccurrences = maxOccurrences;
        this.lowerCasePrefix = attribute.toLowerCase();
        this.requiredPrefix = String.valueOf(attribute) + ": ";
    }

    public void setAllowedValues(String[] allowedValues) {
        this.allowedValues = Arrays.asList(allowedValues);
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        if (this.isEmpty(fileText)) {
            return;
        }
        String[] lines = fileText.toLinesArray();
        List bundleVendors = Arrays.stream(lines).filter(line -> line.toLowerCase().startsWith(this.lowerCasePrefix)).collect(Collectors.toList());
        boolean tooMany = false;
        if (bundleVendors.size() == 0) {
            this.log(0, String.format("\"%s\" is missing", this.attribute), new Object[0]);
            return;
        }
        if (bundleVendors.size() > this.maxOccurrences) {
            tooMany = true;
        }
        int lineNumber = 0;
        for (String bundleVendor : bundleVendors) {
            lineNumber = this.findLineNumberSafe(fileText, bundleVendor, lineNumber, "Bundle vendor line number not found.");
            if (tooMany) {
                this.log(lineNumber, String.format("Only %d \"%s\" was expected.", this.maxOccurrences, this.attribute), new Object[0]);
            }
            if (!bundleVendor.startsWith(this.requiredPrefix)) {
                this.log(lineNumber, String.format("Expect eg. \"%s%s\" got \"%s\"", this.requiredPrefix, this.exampleValue, bundleVendor), new Object[0]);
                continue;
            }
            String onlyValue = bundleVendor.replace(this.requiredPrefix, "");
            if (this.allowedValues.contains(onlyValue)) continue;
            this.log(lineNumber, String.format("Unexpected \"%s\", only allowed options: %s", onlyValue, this.allowedValues), new Object[0]);
        }
    }
}

