/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class AuthorContributionDescriptionCheck
extends AbstractCheck {
    private boolean checkInnerUnits;
    private static final String AUTHOR_TAG = "@author";
    private static final String WARNING_MESSAGE_OTHER_AUTHOR_DESCRIPTION = "Javadoc author should not have empty contribution description.";
    private static final String WARNING_MESSAGE_PREFIX = "First javadoc author should have \"";
    private static final String WARNING_MESSAGE_SUFFIX = "\" contribution description.";
    private static final String WARNING_MESSAGE_DELIMITER = "\", \"";
    private List<String> requiredContributionDescriptions;
    private String warningMessageFirstAuthorDescription;
    private static final int MIN_TOKENS_BY_WHITESPACE = 4;
    private static final int MIN_TOKENS_BY_DASH = 2;
    private static final int CONTRIBUTION_DESCRIPTION_POSITION = 1;

    public void setCheckInnerUnits(boolean checkInnerUnits) {
        this.checkInnerUnits = checkInnerUnits;
    }

    public void setRequiredContributionDescriptions(String[] contributionDescriptions) {
        this.requiredContributionDescriptions = new ArrayList<String>(Arrays.asList(contributionDescriptions));
        this.setWarningMessageFirstAuthorDescription(this.requiredContributionDescriptions);
    }

    private void setWarningMessageFirstAuthorDescription(List<String> contributionDescriptions) {
        this.warningMessageFirstAuthorDescription = contributionDescriptions.stream().map(Object::toString).collect(Collectors.joining(WARNING_MESSAGE_DELIMITER, WARNING_MESSAGE_PREFIX, WARNING_MESSAGE_SUFFIX)).toString();
    }

    public void visitToken(DetailAST ast) {
        if (!this.checkInnerUnits) {
            DetailAST astParent = ast.getParent();
            if (astParent == null) {
                this.visit(ast);
            }
        } else {
            this.visit(ast);
        }
    }

    public void visit(DetailAST ast) {
        int typeDefinitionLineNumber;
        FileContents contents = this.getFileContents();
        TextBlock textBlock = contents.getJavadocBefore(typeDefinitionLineNumber = ast.getLineNo());
        if (textBlock != null) {
            this.checkIfAuthorTagHasDescription(typeDefinitionLineNumber, textBlock.getText());
        }
    }

    private void checkIfAuthorTagHasDescription(int typeDefinitionLineNumber, String ... javadocComment) {
        int authorTagCount = 0;
        int javadocLineIndex = 0;
        while (javadocLineIndex < javadocComment.length) {
            String commentLine = javadocComment[javadocLineIndex];
            if (commentLine.contains(AUTHOR_TAG)) {
                int authorTagLineNumber = typeDefinitionLineNumber - javadocComment.length + javadocLineIndex;
                if (++authorTagCount == 1) {
                    this.checkAuthorContributionDescription(authorTagLineNumber, commentLine, true, this.warningMessageFirstAuthorDescription);
                } else {
                    this.checkAuthorContributionDescription(authorTagLineNumber, commentLine, false, WARNING_MESSAGE_OTHER_AUTHOR_DESCRIPTION);
                }
            }
            ++javadocLineIndex;
        }
    }

    private void checkAuthorContributionDescription(int authorTagLineNumber, String commentLine, boolean isFirstAuthor, String warningMessage) {
        String[] wordsInLine = commentLine.split(" ");
        if (wordsInLine.length < 4 || !commentLine.contains(" - ")) {
            this.log(authorTagLineNumber, warningMessage, new Object[0]);
        } else {
            String[] linePartsByDash = commentLine.split(" - ");
            if (isFirstAuthor) {
                this.checkFirstAuthorContributionDescription(linePartsByDash, authorTagLineNumber, warningMessage);
            } else {
                this.checkOtherAuthorContributionDescription(linePartsByDash, authorTagLineNumber, warningMessage);
            }
        }
    }

    private void checkFirstAuthorContributionDescription(String[] linePartsByDash, int authorTagLineNumber, String warningMessage) {
        String firstAuthorDescription = linePartsByDash[1].trim();
        boolean isDescriptionValid = false;
        for (String contributionDescription : this.requiredContributionDescriptions) {
            if (!StringUtils.containsIgnoreCase((CharSequence)firstAuthorDescription, (CharSequence)contributionDescription)) continue;
            isDescriptionValid = true;
            break;
        }
        if (!isDescriptionValid) {
            this.log(authorTagLineNumber, warningMessage, new Object[0]);
        }
    }

    private void checkOtherAuthorContributionDescription(String[] linePartsByDash, int authorTagLineNumber, String warningMessage) {
        if (linePartsByDash.length < 2 || linePartsByDash[1].trim().isEmpty()) {
            this.log(authorTagLineNumber, warningMessage, new Object[0]);
        }
    }

    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    public int[] getAcceptableTokens() {
        return new int[]{15, 14, 154};
    }

    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }
}

