/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavadocMethodStyleCheck
extends AbstractCheck {
    private static final Pattern CONTAINS_DASH_PATTERN = CommonUtil.createPattern((String)"@(throws|exception|param|return){1}\\s+(\\w+)?\\s*\\-+");
    private static final Pattern DESCRIPTION_ON_NEW_LINE_PATTERN = CommonUtil.createPattern((String)"@(throws|exception|param|return){1}\\s*(\\w+)?\\s*\\-*\\s*(\\*{1}(\\s*\\w+)+)", (int)8);
    private static final Pattern TAG_PATTERN = CommonUtil.createPattern((String)"@(throws|exception|param|return){1}");
    private static final String MESSAGE_DASH_BETWEEN_PARAM_NAME_DESCRIPTION = "There should be no dash between the parameter name and the description in a Javadoc comment of a method or constructor.";
    private static final String MESSAGE_EMPTY_LINE_BETWEEN_TAGS = "There should be no empty lines between tags in a Javadoc comment of a method or constructor.";
    private static final String MESSAGE_PARAMETER_DESCRIPTION_NEW_LINE = "The parameter description in a Javadoc comment of a method or constructor should not start on a new line.";
    private static final int GROUP_DASH = 0;
    private static final int GROUP_NEW_LINE = 3;
    private Map<Integer, String> lineNumberToLineText;
    private List<Integer> tagLines;
    private boolean allowMissingPropertyJavadoc;

    public void setAllowMissingPropertyJavadoc(boolean allowMissingPropertyJavadoc) {
        this.allowMissingPropertyJavadoc = allowMissingPropertyJavadoc;
    }

    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    public int[] getAcceptableTokens() {
        return new int[]{9, 8};
    }

    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    public void visitToken(DetailAST ast) {
        boolean skipCheck;
        boolean bl = skipCheck = (CheckUtil.isSetterMethod((DetailAST)ast) || CheckUtil.isGetterMethod((DetailAST)ast)) && this.allowMissingPropertyJavadoc;
        if (!skipCheck) {
            this.visit(ast);
        }
    }

    private void visit(DetailAST ast) {
        int methodLineNumber;
        FileContents contents = this.getFileContents();
        TextBlock textBlock = contents.getJavadocBefore(methodLineNumber = ast.getLineNo());
        if (textBlock != null) {
            String[] text = textBlock.getText();
            this.lineNumberToLineText = new HashMap<Integer, String>();
            this.tagLines = new ArrayList<Integer>();
            int javadocLineIndex = 0;
            while (javadocLineIndex < text.length) {
                int lineNo = methodLineNumber - text.length + javadocLineIndex;
                String line = text[javadocLineIndex];
                Matcher tagMatcher = TAG_PATTERN.matcher(line);
                if (tagMatcher.find()) {
                    this.tagLines.add(javadocLineIndex);
                }
                this.lineNumberToLineText.put(lineNo, line);
                ++javadocLineIndex;
            }
            this.checkComment(methodLineNumber, text);
        }
    }

    private void checkComment(int methodLineNumber, String[] javadocComment) {
        String group;
        String joinedText = String.join((CharSequence)"\n", javadocComment);
        Matcher containsDashMatcher = CONTAINS_DASH_PATTERN.matcher(joinedText);
        Matcher descriptionNewLineMatcher = DESCRIPTION_ON_NEW_LINE_PATTERN.matcher(joinedText);
        while (containsDashMatcher.find()) {
            group = containsDashMatcher.group(0);
            this.logInformation(group, MESSAGE_DASH_BETWEEN_PARAM_NAME_DESCRIPTION);
        }
        while (descriptionNewLineMatcher.find()) {
            group = descriptionNewLineMatcher.group(3);
            this.logInformation(group, MESSAGE_PARAMETER_DESCRIPTION_NEW_LINE);
        }
        if (this.tagLines.size() > 1) {
            int firstTagLine = this.tagLines.get(0);
            int lastTagLine = this.tagLines.get(this.tagLines.size() - 1);
            int javadocLineIndex = firstTagLine + 1;
            while (javadocLineIndex < lastTagLine) {
                String commentLine = javadocComment[javadocLineIndex];
                if ((commentLine = commentLine.replace("*", " ").trim()).isEmpty()) {
                    int lineNo = methodLineNumber - javadocComment.length + javadocLineIndex;
                    this.log(lineNo, MESSAGE_EMPTY_LINE_BETWEEN_TAGS, new Object[0]);
                }
                ++javadocLineIndex;
            }
        }
    }

    private void logInformation(String group, String message) {
        this.lineNumberToLineText.forEach((lineNumber, lineText) -> {
            if (lineText.contains(group)) {
                this.log((int)lineNumber, message, new Object[0]);
                return;
            }
        });
    }
}

