/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.tools.analysis.checkstyle.api.AbstractStaticCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@NonNullByDefault
public class KarafAddonFeatureCheck
extends AbstractStaticCheck {
    public static final String FEATURE_XML = "feature.xml";
    public static final Path FEATURE_XML_PATH = Path.of("src", "main", "feature", "feature.xml");
    public static final String MSG_MISSING_FEATURE_XML = "Missing feature file {0}";
    public static final String MSG_FEATURES_NAME_INVALID = "Invalid features name, expected name starting with: {0}";
    public static final String MSG_FEATURE_NAME_INVALID = "Invalid feature name, expected name: {0}";
    public static final String BUNDLE_VALUE = "mvn:org.openhab.addons.bundles/{0}/$'{'project.version'}'";
    public static final String MSG_BUNDLE_INVALID = "Invalid or missing bundle entry. Expected <bundle start-level=\"80\">{0}</bundle>";
    private static final String FEATURES_NAME_EXPRESSION = "//features[@name]/@name";
    private static final String FEATURES_SEARCH = "<features";
    private static final String FEATURE_NAME_EXPRESSION = "//features/feature[@name]/@name";
    private static final String FEATURE_SEARCH = "<feature ";
    private static final String BUNDLE_EXPRESSION = "//features/feature/bundle/text()";
    private static final String BUNDLE_SEARCH = "mvn:org.openhab.addons.bundles";
    private static final String POM_ARTIFACT_ID_XPATH_EXPRESSION = "//project/artifactId/text()";
    private static final String POM_PARENT_ARTIFACT_ID = "org.openhab.addons.reactor.bundles";
    private static final String POM_PARENT_ARTIFACT_ID_XPATH_EXPRESSION = "//project/parent/artifactId/text()";
    private final Logger logger = LoggerFactory.getLogger(KarafAddonFeatureCheck.class);
    private final Map<String, String> featureNamePatternsMap = new LinkedHashMap<String, String>();
    private final List<Pattern> excludeAddonsList = new ArrayList<Pattern>();

    public KarafAddonFeatureCheck() {
        this.setFileExtensions(new String[]{"xml"});
    }

    public void setFeatureNameMappings(String featureNameMappings) {
        if (featureNameMappings.trim().isBlank()) {
            return;
        }
        String[] stringArray = featureNameMappings.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            String[] keypair = pattern.split(":");
            if (keypair.length == 2) {
                this.featureNamePatternsMap.put(keypair[0], keypair[1]);
            } else {
                this.logger.warn("{} check pattern for option featureNamePatterns is invalid. Value set: {}", (Object)((Object)((Object)this)).getClass().getName(), (Object)featureNameMappings);
            }
            ++n2;
        }
    }

    public void setExcludeAddonPatterns(String excludeAddonPatterns) {
        if (excludeAddonPatterns.trim().isBlank()) {
            return;
        }
        String[] stringArray = excludeAddonPatterns.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            this.excludeAddonsList.add(Pattern.compile(pattern));
            ++n2;
        }
    }

    protected void processFiltered(@Nullable File file, @Nullable FileText fileText) throws CheckstyleException {
        if (file == null || fileText == null) {
            return;
        }
        switch (file.getName()) {
            case "pom.xml": {
                this.checkMissingFeatureFile(file, fileText);
                break;
            }
            case "feature.xml": {
                this.checkFeatureFile(file, fileText);
            }
        }
    }

    private void checkMissingFeatureFile(File file, FileText fileText) throws CheckstyleException {
        String artifactId = this.getArtifactId(fileText);
        if (artifactId == null) {
            this.logger.debug("{} will be skipped. Could not find Maven group ID (parent group ID) or artifact ID in {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)file.getAbsolutePath());
            return;
        }
        String parent = file.getParent();
        File featureFile = new File(parent, FEATURE_XML_PATH.toString());
        if (!featureFile.exists()) {
            if (this.isExcludedAddon(parent)) {
                this.logger.debug("Ignore check on none exisiting feature name {}", (Object)featureFile);
            } else {
                this.logMessage(featureFile.toString(), 0, FEATURE_XML, MessageFormat.format(MSG_MISSING_FEATURE_XML, featureFile));
            }
        }
    }

    private void checkFeatureFile(File featureFile, FileText fileText) throws CheckstyleException {
        try {
            String featureFileString = featureFile.getAbsoluteFile().toString();
            String addonPath = featureFileString.replace(FEATURE_XML_PATH.toString(), "");
            if (this.isExcludedAddon(new File(addonPath).getName())) {
                this.logger.debug("Ignore check on excluded addon with feature name {}", (Object)featureFile);
                return;
            }
            FileText pomFile = new FileText(new File(addonPath, "pom.xml"), StandardCharsets.UTF_8.name());
            String artifactId = this.getArtifactId(pomFile);
            if (artifactId == null) {
                this.logger.debug("Ignore check on feature.xml with no bundle specific pom.xml: {}", (Object)featureFileString);
            } else {
                Document featureXML = this.parseDomDocumentFromFile(fileText);
                this.checkFeatures(featureFile, artifactId, fileText, featureXML);
                this.checkFeature(featureFile, artifactId, fileText, featureXML);
                this.checkBundle(featureFile, artifactId, fileText, featureXML);
            }
        }
        catch (IOException e) {
            this.logger.error("Could not read {}", (Object)FEATURE_XML_PATH);
        }
    }

    private boolean isExcludedAddon(String parent) {
        return this.excludeAddonsList.stream().anyMatch(p -> p.matcher(parent).find());
    }

    private void checkFeatures(File featureFile, String artifactId, FileText fileText, Document featureXML) {
        this.checkName(featureFile, artifactId, fileText, featureXML, FEATURES_NAME_EXPRESSION, name -> !artifactId.equals(name.substring(0, name.indexOf(45))), MSG_FEATURES_NAME_INVALID, FEATURES_SEARCH);
    }

    private void checkFeature(File featureFile, String artifactId, FileText fileText, Document featureXML) {
        String featureName = this.adaptedFeatureName(artifactId);
        this.checkName(featureFile, featureName, fileText, featureXML, FEATURE_NAME_EXPRESSION, name -> !featureName.equals(name), MSG_FEATURE_NAME_INVALID, FEATURE_SEARCH);
    }

    private String adaptedFeatureName(String artifactId) {
        String featureName = artifactId.substring(4).replaceAll("\\.", "-");
        for (Map.Entry<String, String> entry : this.featureNamePatternsMap.entrySet()) {
            featureName = featureName.replace(entry.getKey(), entry.getValue());
        }
        return featureName;
    }

    private void checkName(File featureFile, String expectedName, FileText fileText, Document featureXML, String expression, Function<String, Boolean> checkFunction, String message, String lineSearchString) {
        Node featuresName = this.getFirstNode(featureXML, expression);
        String errorMessage = MessageFormat.format(message, expectedName);
        if (featuresName == null) {
            this.logMessage(featureFile.getAbsolutePath(), 0, featureFile.getName(), errorMessage);
        } else {
            String name = featuresName.getNodeValue();
            if (name == null || checkFunction.apply(name).booleanValue()) {
                this.logMessage(featureFile.getAbsolutePath(), this.findLineNumberSafe(fileText, lineSearchString, 0, errorMessage), featureFile.getName(), errorMessage);
            }
        }
    }

    private void checkBundle(File featureFile, String artifactId, FileText fileText, Document document) {
        String errorMessage = MessageFormat.format(MSG_BUNDLE_INVALID, BUNDLE_VALUE.replace("{0}", artifactId));
        try {
            XPathExpression artifactIdExpression = this.compileXPathExpression(BUNDLE_EXPRESSION);
            NodeList bundles = (NodeList)artifactIdExpression.evaluate(document, XPathConstants.NODESET);
            String expectedBundleValue = MessageFormat.format(BUNDLE_VALUE, artifactId);
            boolean found = false;
            int i = 0;
            while (i < bundles.getLength()) {
                Node item = bundles.item(i);
                if (expectedBundleValue.equals(item.getNodeValue())) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                this.logMessage(featureFile.getAbsolutePath(), this.findLineNumberSafe(fileText, BUNDLE_SEARCH, 0, errorMessage), featureFile.getName(), errorMessage);
            }
        }
        catch (CheckstyleException | XPathExpressionException e) {
            this.logMessage(featureFile.getAbsolutePath(), 0, featureFile.getName(), errorMessage);
        }
    }

    private @Nullable String getArtifactId(FileText fileText) throws CheckstyleException {
        Document documentXML = this.parseDomDocumentFromFile(fileText);
        Node artifactId = this.getFirstNode(documentXML, POM_ARTIFACT_ID_XPATH_EXPRESSION);
        Node parentArtifactId = this.getFirstNode(documentXML, POM_PARENT_ARTIFACT_ID_XPATH_EXPRESSION);
        return artifactId == null || parentArtifactId == null || !POM_PARENT_ARTIFACT_ID.equals(parentArtifactId.getNodeValue()) ? null : artifactId.getNodeValue();
    }

    private @Nullable Node getFirstNode(Document document, String xpathExpression) {
        try {
            XPathExpression artifactIdExpression = this.compileXPathExpression(xpathExpression);
            return ((NodeList)artifactIdExpression.evaluate(document, XPathConstants.NODESET)).item(0);
        }
        catch (CheckstyleException | XPathExpressionException e) {
            this.logger.error("Could not evaluate XPath expression {}", (Object)xpathExpression, (Object)e);
            return null;
        }
    }
}

