/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.openhab.tools.analysis.checkstyle.api.AbstractOhInfXmlCheck;
import org.openhab.tools.analysis.utils.CachingHttpClient;
import org.openhab.tools.analysis.utils.ContentReceviedCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class OhInfXmlValidationCheck
extends AbstractOhInfXmlCheck {
    private static final String MESSAGE_NOT_INCLUDED_XML_FILE = "The file {0} isn't included in the build.properties file. Good approach is to include all files by adding `OH-INF/` value to the bin.includes property.";
    private final Logger logger = LoggerFactory.getLogger(OhInfXmlValidationCheck.class);
    private Map<Path, File> ohInfFiles = new HashMap<Path, File>();
    private IBuild buildPropertiesFile;
    private String thingSchema;
    private String bindingSchema;
    private String configSchema;
    private static Schema thingSchemaFile;
    private static Schema bindingSchemaFile;
    private static Schema configSchemaFile;

    public void setThingSchema(String thingSchema) {
        this.thingSchema = thingSchema;
    }

    public void setBindingSchema(String bindingSchema) {
        this.bindingSchema = bindingSchema;
    }

    public void setConfigSchema(String configSchema) {
        this.configSchema = configSchema;
    }

    public OhInfXmlValidationCheck() {
        this.setFileExtensions(new String[]{"xml", "properties"});
    }

    @Override
    public void beginProcessing(String charset) {
        ContentReceviedCallback<Schema> callback = new ContentReceviedCallback<Schema>(){
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");

            @Override
            public Schema transform(byte[] content) {
                try {
                    ByteArrayInputStream is = new ByteArrayInputStream(content);
                    return this.schemaFactory.newSchema(new StreamSource(is));
                }
                catch (SAXException e) {
                    OhInfXmlValidationCheck.this.logger.error("Unable to parse schema", (Throwable)e);
                    return null;
                }
            }
        };
        CachingHttpClient<Schema> cachingClient = new CachingHttpClient<Schema>(callback);
        bindingSchemaFile = this.getXSD(this.bindingSchema, cachingClient);
        thingSchemaFile = this.getXSD(this.thingSchema, cachingClient);
        configSchemaFile = this.getXSD(this.configSchema, cachingClient);
        super.beginProcessing(charset);
    }

    public void finishProcessing() {
        this.checkBuildProperties();
    }

    @Override
    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        this.logger.debug("Processing the {}", (Object)file.getName());
        if (file.getName().equals("build.properties")) {
            this.processBuildProperties(fileText);
        } else {
            super.processFiltered(file, fileText);
        }
    }

    private void checkBuildProperties() {
        if (this.buildPropertiesFile != null) {
            IBuildEntry binIncludes = this.buildPropertiesFile.getEntry("bin.includes");
            if (binIncludes != null) {
                String[] includedTokens;
                String[] stringArray = includedTokens = binIncludes.getTokens();
                int n = includedTokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String included = stringArray[n2];
                    Iterator<Map.Entry<Path, File>> it = this.ohInfFiles.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<Path, File> entry = it.next();
                        if (!entry.getKey().startsWith(included)) continue;
                        it.remove();
                    }
                    ++n2;
                }
            }
            this.logMissingEntries(this.ohInfFiles, MESSAGE_NOT_INCLUDED_XML_FILE);
        }
    }

    @Override
    protected void checkConfigFile(FileText xmlFileText) throws CheckstyleException {
        File xmlFile = xmlFileText.getFile();
        this.addToOhFiles(xmlFile);
        this.validateXmlAgainstSchema(xmlFile, configSchemaFile);
    }

    @Override
    protected void checkBindingFile(FileText xmlFileText) throws CheckstyleException {
        File xmlFile = xmlFileText.getFile();
        this.addToOhFiles(xmlFile);
        this.validateXmlAgainstSchema(xmlFile, bindingSchemaFile);
    }

    @Override
    protected void checkThingTypeFile(FileText xmlFileText) throws CheckstyleException {
        File xmlFile = xmlFileText.getFile();
        this.addToOhFiles(xmlFile);
        this.validateXmlAgainstSchema(xmlFile, thingSchemaFile);
    }

    private void processBuildProperties(FileText fileText) {
        try {
            this.buildPropertiesFile = this.parseBuildProperties(fileText);
        }
        catch (CheckstyleException e) {
            this.logger.error("Problem occurred while parsing the file {}", (Object)fileText.getFile().getPath(), (Object)e);
        }
    }

    private void validateXmlAgainstSchema(File xmlFile, Schema schema) {
        if (schema != null) {
            try {
                Validator validator = schema.newValidator();
                validator.validate(new StreamSource(xmlFile));
            }
            catch (SAXParseException exception) {
                String message = exception.getMessage();
                message = message.substring(message.indexOf(":") + 2);
                int lineNumber = exception.getLineNumber();
                this.log(lineNumber, message, new Object[]{xmlFile.getPath()});
            }
            catch (IOException | SAXException e) {
                this.logger.error("Problem occurred while parsing the file {}", (Object)xmlFile.getName(), (Object)e);
            }
        } else {
            this.logger.warn("XML validation will be skipped as the schema file download failed.");
        }
    }

    private <K> void logMissingEntries(Map<K, File> collection, String message) {
        for (K element : collection.keySet()) {
            File xmlFile = collection.get(element);
            this.logMessage(xmlFile.getPath(), 0, xmlFile.getName(), MessageFormat.format(message, element));
        }
    }

    private void addToOhFiles(File xmlFile) {
        Path filePath = xmlFile.toPath();
        Path bundlePath = filePath.getParent().getParent().getParent();
        Path relativePath = bundlePath.relativize(filePath);
        this.ohInfFiles.put(relativePath, xmlFile);
    }

    private Schema getXSD(String schemaUrlString, CachingHttpClient<Schema> client) {
        try {
            URL schemaUrl = new URL(schemaUrlString);
            return client.get(schemaUrl);
        }
        catch (IOException e) {
            this.logger.error("Unable to get XSD file {} : {}", new Object[]{schemaUrlString, e.getMessage(), e});
            return null;
        }
    }
}

