/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.openhab.tools.analysis.checkstyle.api.AbstractStaticCheck;

public class OnlyTabIndentationCheck
extends AbstractStaticCheck {
    private static final String TAB_CHARACTER = "\t";
    private static final String WARNING_MESSAGE = "There were whitespace characters used for indentation. Please use tab characters instead";
    private boolean onlyShowFirstWarning;

    public void setOnlyShowFirstWarning(Boolean showFirstExceptionOnly) {
        this.onlyShowFirstWarning = showFirstExceptionOnly;
    }

    public void setFileTypes(String[] value) {
        this.setFileExtensions(value);
    }

    protected void processFiltered(File file, FileText fileText) {
        this.processTabIdentationCheck(fileText);
    }

    private void processTabIdentationCheck(FileText fileText) {
        int lineNumber = 0;
        while (lineNumber < fileText.size()) {
            String line = fileText.get(lineNumber);
            if (line.trim().isEmpty() && !this.doesLineContainOnlyTabs(line)) {
                if (this.onlyShowFirstWarning) {
                    this.logMessage(lineNumber);
                    return;
                }
                this.logMessage(lineNumber);
            } else {
                String lineBeforeCharacter;
                int indexNonWhitespaceCharacter = line.indexOf(line.trim());
                if (indexNonWhitespaceCharacter > 0 && !this.doesLineContainOnlyTabs(lineBeforeCharacter = line.substring(0, indexNonWhitespaceCharacter))) {
                    if (this.onlyShowFirstWarning) {
                        this.logMessage(lineNumber);
                        return;
                    }
                    this.logMessage(lineNumber);
                }
            }
            ++lineNumber;
        }
    }

    private boolean doesLineContainOnlyTabs(String lineBeforeCharacter) {
        return StringUtils.containsOnly((CharSequence)lineBeforeCharacter, (String)TAB_CHARACTER);
    }

    private void logMessage(int lineNumber) {
        this.log(lineNumber + 1, WARNING_MESSAGE, new Object[0]);
    }
}

