/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.List;
import org.openhab.tools.analysis.checkstyle.api.AbstractExternalLibrariesCheck;

public class OutsideOfLibExternalLibrariesCheck
extends AbstractExternalLibrariesCheck {
    private List<String> ignoredDirectories;
    private static final String JAR_FILES_NEED_TO_BE_PLACED_IN_A_LIB_FOLDER = "There is a jar outside of the lib folder %s" + File.separator + "%s";

    public OutsideOfLibExternalLibrariesCheck() {
        this.setFileExtensions(new String[]{"properties"});
    }

    public void setIgnoredDirectories(String[] values) {
        this.ignoredDirectories = Arrays.asList(values);
    }

    private void checkBundleForOutOfPlaceJarFiles(File bundleDirectory, final String folderToSkip) {
        File[] files = bundleDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.equals(folderToSkip) || OutsideOfLibExternalLibrariesCheck.this.containsIgnoredDirectories(name)) {
                    return false;
                }
                if (name.endsWith(".jar")) {
                    OutsideOfLibExternalLibrariesCheck.this.log(0, String.format(JAR_FILES_NEED_TO_BE_PLACED_IN_A_LIB_FOLDER, dir.getAbsolutePath(), name), new Object[0]);
                }
                return dir.isDirectory();
            }
        });
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.checkBundleForOutOfPlaceJarFiles(file, null);
                ++n2;
            }
        }
    }

    private boolean containsIgnoredDirectories(String directoryName) {
        return this.ignoredDirectories.contains(directoryName);
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        if (!file.getName().equals("build.properties")) {
            return;
        }
        File bundleDirectory = file.getParentFile();
        this.checkBundleForOutOfPlaceJarFiles(bundleDirectory, "lib");
    }
}

