/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;
import org.openhab.tools.analysis.checkstyle.api.AbstractStaticCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequireBundleCheck
extends AbstractStaticCheck {
    private final Logger logger = LoggerFactory.getLogger(RequireBundleCheck.class);
    private List<String> allowedRequireBundles = Collections.emptyList();

    public RequireBundleCheck() {
        this.setFileExtensions(new String[]{"MF"});
    }

    public void setAllowedRequireBundles(String[] bundles) {
        this.allowedRequireBundles = Arrays.asList(bundles);
    }

    protected void processFiltered(File file, FileText fileText) {
        block7: {
            try {
                String[] bundleNames;
                String requireBundleHeaderValue;
                Manifest manifest = new Manifest(new FileInputStream(file));
                Attributes attributes = manifest.getMainAttributes();
                String fragmentHost = attributes.getValue("Fragment-Host");
                String bundleSymbolicName = attributes.getValue("Bundle-SymbolicName");
                boolean testBundle = false;
                if (StringUtils.isNotBlank((CharSequence)fragmentHost) && StringUtils.isNotBlank((CharSequence)bundleSymbolicName)) {
                    boolean bl = testBundle = bundleSymbolicName.startsWith(fragmentHost) && bundleSymbolicName.substring(fragmentHost.length()).startsWith(".test");
                }
                if ((requireBundleHeaderValue = attributes.getValue("Require-Bundle")) != null && !testBundle) {
                    int lineNumber = this.findLineNumberSafe(fileText, requireBundleHeaderValue, 0, "Require-Bundle header line number not found.");
                    this.log(lineNumber, "The MANIFEST.MF file must not contain any Require-Bundle entries. Instead, Import-Package must be used.", new Object[0]);
                    break block7;
                }
                if (requireBundleHeaderValue == null || !testBundle) break block7;
                String[] stringArray = bundleNames = requireBundleHeaderValue.split(",");
                int n = bundleNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String bundleName = stringArray[n2];
                    if (!this.allowedRequireBundles.contains(bundleName)) {
                        int lineNumber = this.findLineNumberSafe(fileText, requireBundleHeaderValue, 0, "Header value not found.");
                        this.log(lineNumber, "The MANIFEST.MF file of a test fragment must not contain Require-Bundle entries other than " + this.getAllowedBundlesString() + ".", new Object[0]);
                        break;
                    }
                    ++n2;
                }
            }
            catch (FileNotFoundException e) {
                this.logger.error("An exception was thrown while trying to open the file {}", (Object)file.getPath(), (Object)e);
            }
            catch (IOException e) {
                this.logger.error("An exception was thrown while trying to read the file {}", (Object)file.getPath(), (Object)e);
            }
        }
    }

    private String getAllowedBundlesString() {
        StringBuilder sb = new StringBuilder();
        for (String bundleName : this.allowedRequireBundles) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(bundleName);
        }
        return sb.toString();
    }
}

