/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.openhab.tools.analysis.checkstyle.api.AbstractStaticCheck;

public class RequiredFilesCheck
extends AbstractStaticCheck {
    private Path projectRootPath;
    private List<Path> requiredFiles;
    private List<Path> foundFiles = new ArrayList<Path>();

    public void setExtensions(String[] extensions) {
        this.setFileExtensions(extensions);
    }

    public void setRequiredFiles(String[] files) {
        this.requiredFiles = Arrays.stream(files).map(string -> Paths.get(string, new String[0])).collect(Collectors.toList());
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        Path absoluteFilePath = file.toPath();
        for (Path relativeRequiredPath : this.requiredFiles) {
            if (!absoluteFilePath.endsWith(relativeRequiredPath)) continue;
            if (this.projectRootPath == null) {
                this.projectRootPath = this.getRootPath(absoluteFilePath, relativeRequiredPath);
            }
            this.foundFiles.add(relativeRequiredPath);
        }
    }

    private Path getRootPath(Path absolute, Path relative) {
        Path root = absolute;
        int i = 0;
        while (i < relative.getNameCount()) {
            root = root.getParent();
            ++i;
        }
        return root;
    }

    public void finishProcessing() {
        ArrayList<Path> notFoundFiles = new ArrayList<Path>(this.requiredFiles);
        notFoundFiles.removeAll(this.foundFiles);
        for (Path path : notFoundFiles) {
            this.logMessage(path);
        }
    }

    private void logMessage(Path path) {
        path = this.projectRootPath != null ? this.projectRootPath.resolve(path) : Paths.get(File.separator, new String[0]).resolve(path);
        String fileName = path.getFileName().toString();
        String message = String.format("Missing %s file.", fileName);
        this.logMessage(path.toString(), 0, fileName, message);
    }
}

