/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.ManifestParser;
import org.eclipse.core.internal.filebuffers.SynchronizableDocument;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.internal.core.text.build.BuildModel;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.openhab.tools.analysis.checkstyle.api.NoResultException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class AbstractStaticCheck
extends AbstractFileSetCheck {
    private final Logger logger = LoggerFactory.getLogger(AbstractStaticCheck.class);

    protected int findLineNumber(FileText fileContent, String searchedText, int startLineNumber) throws NoResultException {
        int lineNumber = startLineNumber;
        while (lineNumber < fileContent.size()) {
            String line = fileContent.get(lineNumber);
            if (line.contains(searchedText)) {
                return lineNumber + 1;
            }
            ++lineNumber;
        }
        String message = MessageFormat.format("`{0}` was not found in the file {1} starting from line `{2}`. Check if it is split between multiple lines or it is missing", searchedText, fileContent.getFile().getAbsolutePath(), startLineNumber);
        throw new NoResultException(message);
    }

    protected int findLineNumberSafe(FileText fileText, String searchedText, int startLineNumber, String warningMessage) {
        try {
            return this.findLineNumber(fileText, searchedText, startLineNumber);
        }
        catch (NoResultException e) {
            this.logger.warn("{} Fall back to 0.", (Object)warningMessage, (Object)e);
            return 0;
        }
    }

    protected org.w3c.dom.Document parseDomDocumentFromFile(FileText fileText) throws CheckstyleException {
        try {
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            org.w3c.dom.Document document = builder.parse(this.getInputStream(fileText));
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new CheckstyleException("Serious configuration error occured while creating a DocumentBuilder.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new CheckstyleException("Unable to read from file: " + fileText.getFile().getAbsolutePath(), (Throwable)e);
        }
        catch (IOException e) {
            throw new CheckstyleException("Unable to open file: " + fileText.getFile().getAbsolutePath(), (Throwable)e);
        }
    }

    protected BundleInfo parseManifestFromFile(FileText fileText) throws CheckstyleException {
        try {
            BundleInfo info = ManifestParser.parseManifest((InputStream)this.getInputStream(fileText));
            return info;
        }
        catch (IOException e) {
            throw new CheckstyleException("Unable to read from file: " + fileText.getFile().getAbsolutePath(), (Throwable)e);
        }
        catch (ParseException e) {
            throw new CheckstyleException("Unable to parse file:" + fileText.getFile().getAbsolutePath(), (Throwable)e);
        }
    }

    protected Properties readPropertiesFromFile(FileText fileText) throws CheckstyleException {
        try {
            Properties properties = new Properties();
            properties.load(this.getInputStream(fileText));
            return properties;
        }
        catch (FileNotFoundException e) {
            throw new CheckstyleException("File: " + fileText.getFile().getAbsolutePath() + " does not exist.", (Throwable)e);
        }
        catch (IOException e) {
            throw new CheckstyleException("Unable to read properties from: " + fileText.getFile().getAbsolutePath(), (Throwable)e);
        }
    }

    protected Document parseHTMLDocumentFromFile(FileText fileText) {
        String fileContent = fileText.getFullText().toString();
        return Jsoup.parse((String)fileContent);
    }

    protected XPathExpression compileXPathExpression(String expresion) throws CheckstyleException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            return xpath.compile(expresion);
        }
        catch (XPathExpressionException e) {
            throw new CheckstyleException("Unable to compile the expression" + expresion, (Throwable)e);
        }
    }

    protected IBuild parseBuildProperties(FileText fileText) throws CheckstyleException {
        SynchronizableDocument document = new SynchronizableDocument();
        BuildModel buildModel = new BuildModel((IDocument)document, false);
        try {
            buildModel.load(this.getInputStream(fileText), true);
            return buildModel.getBuild();
        }
        catch (CoreException e) {
            throw new CheckstyleException("Unable to read build.properties file", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isEmpty(FileText fileText) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getInputStream(fileText)));){
                if (bufferedReader.readLine() != null) return false;
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    protected void logMessage(String filePath, int line, String fileName, String message) {
        MessageDispatcher dispatcher = this.getMessageDispatcher();
        dispatcher.fireFileStarted(filePath);
        this.log(line, message, new Object[]{fileName});
        this.fireErrors(filePath);
        dispatcher.fireFileFinished(filePath);
    }

    protected Node parseMarkdown(FileText fileText, MutableDataSet parsingOptions) {
        Parser parser = Parser.builder((DataHolder)parsingOptions).build();
        return parser.parse(fileText.getFullText().toString());
    }

    private InputStream getInputStream(FileText fileText) {
        return new ByteArrayInputStream(fileText.getFullText().toString().getBytes(fileText.getCharset()));
    }
}

