/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle.readme;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.File;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.openhab.tools.analysis.checkstyle.api.AbstractStaticCheck;
import org.openhab.tools.analysis.checkstyle.readme.MarkdownVisitor;
import org.openhab.tools.analysis.checkstyle.readme.MarkdownVisitorCallback;

public class MarkdownCheck
extends AbstractStaticCheck {
    private static final String ADDED_README_FILE_IN_BUILD_PROPERTIES_MSG = "README.MD file must not be added to the bin.includes property";
    private static final String ADDED_DOC_FOLDER_IN_BUILD_PROPERTIES_MSG = "The doc folder must not be added to the bin.includes property";
    private static final String DOC_FOLDER_NAME = "doc";

    public MarkdownCheck() {
        this.setFileExtensions(new String[]{"md", "properties"});
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        switch (file.getName()) {
            case "build.properties": {
                this.checkBuildProperties(fileText);
                break;
            }
            case "README.md": {
                this.checkReadMe(fileText);
            }
        }
    }

    private void checkBuildProperties(FileText fileText) throws CheckstyleException {
        boolean isDocFolderIncluded;
        IBuild buildPropertiesEntry = this.parseBuildProperties(fileText);
        boolean isReadMeIncluded = this.checkBuildPropertiesEntry(buildPropertiesEntry, "bin.includes", "README.md");
        if (isReadMeIncluded) {
            this.log(0, ADDED_README_FILE_IN_BUILD_PROPERTIES_MSG, new Object[0]);
        }
        if (isDocFolderIncluded = this.checkBuildPropertiesEntry(buildPropertiesEntry, "bin.includes", DOC_FOLDER_NAME)) {
            this.log(0, ADDED_DOC_FOLDER_IN_BUILD_PROPERTIES_MSG, new Object[0]);
        }
    }

    private void checkReadMe(FileText fileText) {
        MutableDataSet options = new MutableDataSet();
        options.set(Parser.TRACK_DOCUMENT_LINES, (Object)true);
        Node readmeMarkdownNode = this.parseMarkdown(fileText, options);
        MarkdownVisitorCallback callBack = new MarkdownVisitorCallback(){

            @Override
            public void log(int line, String message) {
                MarkdownCheck.this.log(line + 1, message, new Object[0]);
            }
        };
        MarkdownVisitor visitor = new MarkdownVisitor(callBack, fileText);
        visitor.visit(readmeMarkdownNode);
    }

    private boolean checkBuildPropertiesEntry(IBuild buildPropertiesFile, String property, String value) throws CheckstyleException {
        IBuildEntry binIncludes = buildPropertiesFile.getEntry(property);
        return binIncludes != null && binIncludes.contains(value);
    }
}

