/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;

public class DeclarativeServicesDependencyInjectionCheck
extends AbstractCheck {
    public static final String SERVICE_TRACKER_CLASS_NAME = "org.osgi.util.tracker.ServiceTracker";
    public static final String SERVICE_CUSTOMIZER_CLASS_NAME = "org.osgi.util.tracker.ServiceTrackerCustomizer";
    public static final String MESSAGE_SERVICE_TRACKER_USED = "Avoid using " + DeclarativeServicesDependencyInjectionCheck.getShortName("org.osgi.util.tracker.ServiceTracker") + " for dependency injection, consider using Declarative Services";
    public static final String MESSAGE_SERVICE_CUSTOMIZER_IMPLEMENTED = "Avoid using " + DeclarativeServicesDependencyInjectionCheck.getShortName("org.osgi.util.tracker.ServiceTrackerCustomizer") + " for dependency injection, consider using Declarative Services";

    public int[] getDefaultTokens() {
        return new int[]{10, 14};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 10: {
                this.checkVariable(ast);
                break;
            }
            case 14: {
                this.checkClass(ast);
            }
        }
    }

    private void checkVariable(DetailAST astNode) {
        DetailAST variableTypeNode = astNode.findFirstToken(13);
        String variableType = this.getType(variableTypeNode);
        if (this.equals(variableType, SERVICE_TRACKER_CLASS_NAME)) {
            this.log(astNode.getLineNo(), MESSAGE_SERVICE_TRACKER_USED, new Object[]{SERVICE_TRACKER_CLASS_NAME});
        }
    }

    private void checkClass(DetailAST astNode) {
        String implementedInterface;
        DetailAST implementedInterfaceNode = astNode.findFirstToken(19);
        if (implementedInterfaceNode != null && this.equals(implementedInterface = this.getType(implementedInterfaceNode), SERVICE_CUSTOMIZER_CLASS_NAME)) {
            this.log(astNode.getLineNo(), MESSAGE_SERVICE_CUSTOMIZER_IMPLEMENTED, new Object[]{SERVICE_CUSTOMIZER_CLASS_NAME});
        }
    }

    private String getType(DetailAST classNode) {
        FullIdent fullType = FullIdent.createFullIdent((DetailAST)classNode.getFirstChild());
        return fullType.getText();
    }

    private static String getShortName(String fullName) {
        return fullName.substring(fullName.lastIndexOf(46) + 1);
    }

    private boolean equals(String className, String otherClassName) {
        String shortClassName = DeclarativeServicesDependencyInjectionCheck.getShortName(className);
        String shortOtherClassName = DeclarativeServicesDependencyInjectionCheck.getShortName(otherClassName);
        return shortClassName.equals(shortOtherClassName);
    }
}

