/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ForbiddenPackageUsageCheck
extends AbstractCheck {
    private static final String MESSAGE = "The package %s should not be used.";
    private Collection<String> forbiddenPackages;
    private Collection<String> exceptions;
    private Map<String, Integer> importsToLineNumbers = new HashMap<String, Integer>();

    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    public int[] getAcceptableTokens() {
        return new int[]{30};
    }

    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    public void setForbiddenPackages(String[] value) {
        this.forbiddenPackages = Arrays.asList(value);
    }

    public void setExceptions(String[] value) {
        this.exceptions = Arrays.asList(value);
    }

    public void visitToken(DetailAST ast) {
        this.importsToLineNumbers.put(FullIdent.createFullIdent((DetailAST)ast.getFirstChild()).getText(), ast.getLineNo());
    }

    public void beginTree(DetailAST rootAST) {
        this.importsToLineNumbers.clear();
    }

    public void finishTree(DetailAST ast) {
        this.importsToLineNumbers.entrySet().stream().filter(entry -> this.forbiddenPackages.stream().anyMatch(((String)entry.getKey())::contains)).filter(entry -> !this.exceptions.stream().anyMatch(((String)entry.getKey())::contains)).forEach(entry -> this.log((Integer)entry.getValue(), String.format(MESSAGE, entry.getKey()), new Object[0]));
    }
}

