/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.openhab.tools.analysis.checkstyle.api.AbstractOhInfXmlCheck;
import org.openhab.tools.analysis.checkstyle.api.CheckConstants;
import org.w3c.dom.NodeList;

public class OhInfXmlUsageCheck
extends AbstractOhInfXmlCheck {
    private static final String CONFIG_DESCRIPTION_EXPRESSION = "//config-description[@uri]/@uri";
    private static final String CONFIG_DESCRIPTION_REF_EXPRESSION = "//config-description-ref[@uri]/@uri";
    private static final String BRIDGE_TYPE_EXPRESSION = "//bridge-type[@id]/@id";
    private static final String SUPPORTED_BRIDGE_TYPE_REF_EXPRESSION = "//supported-bridge-type-refs/bridge-type-ref[@id]/@id";
    private static final String CONFIGURABLE_SERVICE_REF_EXPRESSION = "//component/property[@name='service.config.description.uri']/@value";
    private static final String MESSAGE_MISSING_URI_CONFIGURATION = "Missing configuration for the configuration reference with uri - {0}";
    private static final String MESSAGE_MISSING_SUPPORTED_BRIDGE = "Missing the supported bridge with id {0}";
    private static final String MESSAGE_UNUSED_URI_CONFIGURATION = "Unused configuration reference with uri - {0}";
    private static final String MESSAGE_UNUSED_BRIDGE = "Unused bridge reference with id - {0}";
    private final Map<String, File> allConfigDescriptionRefs = new HashMap<String, File>();
    private final Map<String, File> allConfigDescriptions = new HashMap<String, File>();
    private final Map<String, File> allSupportedBridges = new HashMap<String, File>();
    private final Map<String, File> allBridgeTypes = new HashMap<String, File>();

    public void finishProcessing() {
        Map<String, File> missingSupportedBridges = this.removeAll(this.allSupportedBridges, this.allBridgeTypes);
        this.logMissingEntries(missingSupportedBridges, MESSAGE_MISSING_SUPPORTED_BRIDGE);
        Map<String, File> missingConfigDescriptions = this.removeAll(this.allConfigDescriptionRefs, this.allConfigDescriptions);
        this.logMissingEntries(missingConfigDescriptions, MESSAGE_MISSING_URI_CONFIGURATION);
        Map<String, File> unusedBridges = this.removeAll(this.allBridgeTypes, this.allSupportedBridges);
        this.logMissingEntries(unusedBridges, MESSAGE_UNUSED_BRIDGE);
        Map<String, File> unusedConfigDescriptions = this.removeAll(this.allConfigDescriptions, this.allConfigDescriptionRefs);
        unusedConfigDescriptions.keySet().removeIf(key -> key.startsWith("profile:"));
        if (!unusedConfigDescriptions.isEmpty()) {
            Map<String, File> configurableServiceRefs = this.getConfigurableServiceRefs(unusedConfigDescriptions.values().iterator().next().toPath());
            unusedConfigDescriptions = this.removeAll(unusedConfigDescriptions, configurableServiceRefs);
        }
        this.logMissingEntries(unusedConfigDescriptions, MESSAGE_UNUSED_URI_CONFIGURATION);
    }

    @Override
    protected void checkConfigFile(FileText xmlFileText) throws CheckstyleException {
        this.allConfigDescriptions.putAll(this.evaluateExpressionOnFile(xmlFileText, CONFIG_DESCRIPTION_EXPRESSION));
    }

    @Override
    protected void checkAddonFile(FileText xmlFileText) throws CheckstyleException {
        this.allConfigDescriptionRefs.putAll(this.evaluateExpressionOnFile(xmlFileText, CONFIG_DESCRIPTION_REF_EXPRESSION));
        this.allConfigDescriptions.putAll(this.evaluateExpressionOnFile(xmlFileText, CONFIG_DESCRIPTION_EXPRESSION));
    }

    @Override
    protected void checkThingTypeFile(FileText xmlFileText) throws CheckstyleException {
        this.allSupportedBridges.putAll(this.evaluateExpressionOnFile(xmlFileText, SUPPORTED_BRIDGE_TYPE_REF_EXPRESSION));
        this.allBridgeTypes.putAll(this.evaluateExpressionOnFile(xmlFileText, BRIDGE_TYPE_EXPRESSION));
        this.allConfigDescriptionRefs.putAll(this.evaluateExpressionOnFile(xmlFileText, CONFIG_DESCRIPTION_REF_EXPRESSION));
        this.allConfigDescriptions.putAll(this.evaluateExpressionOnFile(xmlFileText, CONFIG_DESCRIPTION_EXPRESSION));
    }

    private Map<String, File> evaluateExpressionOnFile(FileText xmlFileText, String xPathExpression) throws CheckstyleException {
        HashMap<String, File> collection = new HashMap<String, File>();
        NodeList nodes = this.getNodes(xmlFileText, xPathExpression);
        if (nodes != null) {
            int i = 0;
            while (i < nodes.getLength()) {
                collection.put(nodes.item(i).getNodeValue(), xmlFileText.getFile());
                ++i;
            }
        }
        return collection;
    }

    private Map<String, File> removeAll(Map<String, File> firstMap, Map<String, File> secondMap) {
        HashMap<String, File> result = new HashMap<String, File>(firstMap);
        result.keySet().removeAll(secondMap.keySet());
        return result;
    }

    private void logMissingEntries(Map<String, File> collection, String message) {
        for (Map.Entry<String, File> entry : collection.entrySet()) {
            File xmlFile = entry.getValue();
            this.logMessage(xmlFile.getPath(), 0, xmlFile.getName(), MessageFormat.format(message, entry.getKey()));
        }
    }

    private Map<String, File> getConfigurableServiceRefs(Path basePath) {
        HashMap<String, File> uriFileMap = new HashMap<String, File>();
        Path path = basePath;
        while (path != null) {
            if ("OH-INF".equals(path.getFileName().toString())) {
                Path osgiInfPath = path.resolve("../../../../" + CheckConstants.OSGI_INF_PATH);
                if (!Files.exists(osgiInfPath, new LinkOption[0])) {
                    return uriFileMap;
                }
                try {
                    Files.list(osgiInfPath).forEach(xmlPath -> uriFileMap.putAll(this.getConfigurableServiceRefsFromXml((Path)xmlPath)));
                }
                catch (IOException iOException) {}
                break;
            }
            path = path.getParent();
        }
        return uriFileMap;
    }

    private Map<String, File> getConfigurableServiceRefsFromXml(Path xmlPath) {
        try {
            FileText xmlFileText = new FileText(xmlPath.toFile(), StandardCharsets.UTF_8.name());
            return this.evaluateExpressionOnFile(xmlFileText, CONFIGURABLE_SERVICE_REF_EXPRESSION);
        }
        catch (CheckstyleException | IOException e) {
            return Map.of();
        }
    }
}

