/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.openhab.tools.analysis.checkstyle.api.AbstractOhInfXmlCheck;
import org.openhab.tools.analysis.utils.CachingHttpClient;
import org.openhab.tools.analysis.utils.ContentReceviedCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class OhInfXmlValidationCheck
extends AbstractOhInfXmlCheck {
    private final Logger logger = LoggerFactory.getLogger(OhInfXmlValidationCheck.class);
    private Map<Path, File> ohInfFiles = new HashMap<Path, File>();
    private String thingSchema;
    private String addonSchema;
    private String configSchema;
    private static Schema thingSchemaFile;
    private static Schema addonSchemaFile;
    private static Schema configSchemaFile;

    public void setThingSchema(String thingSchema) {
        this.thingSchema = thingSchema;
    }

    public void setAddonSchema(String addonSchema) {
        this.addonSchema = addonSchema;
    }

    public void setConfigSchema(String configSchema) {
        this.configSchema = configSchema;
    }

    public OhInfXmlValidationCheck() {
        this.setFileExtensions(new String[]{"xml", "properties"});
    }

    @Override
    public void beginProcessing(String charset) {
        ContentReceviedCallback<Schema> callback = new ContentReceviedCallback<Schema>(){
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");

            @Override
            public Schema transform(byte[] content) {
                try {
                    ByteArrayInputStream is = new ByteArrayInputStream(content);
                    return this.schemaFactory.newSchema(new StreamSource(is));
                }
                catch (SAXException e) {
                    OhInfXmlValidationCheck.this.logger.error("Unable to parse schema", (Throwable)e);
                    return null;
                }
            }
        };
        CachingHttpClient<Schema> cachingClient = new CachingHttpClient<Schema>(callback);
        addonSchemaFile = this.getXSD(this.addonSchema, cachingClient);
        thingSchemaFile = this.getXSD(this.thingSchema, cachingClient);
        configSchemaFile = this.getXSD(this.configSchema, cachingClient);
        super.beginProcessing(charset);
    }

    @Override
    protected void checkConfigFile(FileText xmlFileText) throws CheckstyleException {
        File xmlFile = xmlFileText.getFile();
        this.addToOhFiles(xmlFile);
        this.validateXmlAgainstSchema(xmlFile, configSchemaFile);
    }

    @Override
    protected void checkAddonFile(FileText xmlFileText) throws CheckstyleException {
        File xmlFile = xmlFileText.getFile();
        this.addToOhFiles(xmlFile);
        this.validateXmlAgainstSchema(xmlFile, addonSchemaFile);
    }

    @Override
    protected void checkThingTypeFile(FileText xmlFileText) throws CheckstyleException {
        File xmlFile = xmlFileText.getFile();
        this.addToOhFiles(xmlFile);
        this.validateXmlAgainstSchema(xmlFile, thingSchemaFile);
    }

    private void validateXmlAgainstSchema(File xmlFile, Schema schema) {
        if (schema != null) {
            try {
                Validator validator = schema.newValidator();
                validator.validate(new StreamSource(xmlFile));
            }
            catch (SAXParseException exception) {
                String message = exception.getMessage();
                message = message.substring(message.indexOf(":") + 2);
                int lineNumber = exception.getLineNumber();
                this.log(lineNumber, message, new Object[]{xmlFile.getPath()});
            }
            catch (IOException | SAXException e) {
                this.logger.error("Problem occurred while parsing the file {}", (Object)xmlFile.getName(), (Object)e);
            }
        } else {
            this.logger.warn("XML validation will be skipped as the schema file download failed.");
        }
    }

    private void addToOhFiles(File xmlFile) {
        Path filePath = xmlFile.toPath();
        Path bundlePath = filePath.getParent().getParent().getParent();
        Path relativePath = bundlePath.relativize(filePath);
        this.ohInfFiles.put(relativePath, xmlFile);
    }

    private Schema getXSD(String schemaUrlString, CachingHttpClient<Schema> client) {
        try {
            URL schemaUrl = new URL(schemaUrlString);
            return client.get(schemaUrl);
        }
        catch (IOException e) {
            this.logger.error("Unable to get XSD file {} : {}", new Object[]{schemaUrlString, e.getMessage(), e});
            return null;
        }
    }
}

