/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.text.MessageFormat;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FilenameUtils;
import org.openhab.tools.analysis.checkstyle.api.AbstractStaticCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public abstract class AbstractOhInfXmlCheck
extends AbstractStaticCheck {
    public static final String THING_DIRECTORY = "thing";
    public static final String ADDON_DIRECTORY = "addon";
    public static final String CONFIGURATION_DIRECTORY = "config";
    private static final String MESSAGE_EMPTY_FILE = "The file {0} should not be empty.";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public AbstractOhInfXmlCheck() {
        this.setFileExtensions(new String[]{"xml"});
    }

    public void beginProcessing(String charset) {
        this.logger.debug("Executing the {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        String fileName = file.getName();
        if (FilenameUtils.getExtension((String)fileName).equals("xml")) {
            this.processXmlFile(fileText);
        }
    }

    private void processXmlFile(FileText xmlFileText) throws CheckstyleException {
        block14: {
            File xmlFile;
            block13: {
                xmlFile = xmlFileText.getFile();
                if (!this.isEmpty(xmlFileText)) break block13;
                this.log(0, MessageFormat.format(MESSAGE_EMPTY_FILE, xmlFile.getName()), new Object[]{xmlFile.getPath()});
                break block14;
            }
            File fileParentDirectory = xmlFile.getParentFile();
            boolean isOHParentDirectory = "OH-INF".equals(fileParentDirectory.getParentFile().getName());
            if (!isOHParentDirectory) break block14;
            switch (fileParentDirectory.getName()) {
                case "thing": {
                    this.checkThingTypeFile(xmlFileText);
                    break;
                }
                case "addon": {
                    this.checkAddonFile(xmlFileText);
                    break;
                }
                case "config": {
                    this.checkConfigFile(xmlFileText);
                    break;
                }
            }
        }
    }

    protected abstract void checkConfigFile(FileText var1) throws CheckstyleException;

    protected abstract void checkAddonFile(FileText var1) throws CheckstyleException;

    protected abstract void checkThingTypeFile(FileText var1) throws CheckstyleException;

    protected NodeList getNodes(FileText xmlFileText, String expression) throws CheckstyleException {
        Document document = this.parseDomDocumentFromFile(xmlFileText);
        XPathExpression xpathExpression = this.compileXPathExpression(expression);
        NodeList nodes = null;
        try {
            nodes = (NodeList)xpathExpression.evaluate(document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            String message = MessageFormat.format("Problem occurred while evaluating the expression {0} on the {1} file.", expression, xmlFileText.getFile().getName());
            this.log(0, message, new Object[0]);
        }
        return nodes;
    }
}

