/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle.readme;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.File;
import org.openhab.tools.analysis.checkstyle.api.AbstractStaticCheck;
import org.openhab.tools.analysis.checkstyle.readme.MarkdownVisitor;
import org.openhab.tools.analysis.checkstyle.readme.MarkdownVisitorCallback;

public class MarkdownCheck
extends AbstractStaticCheck {
    public MarkdownCheck() {
        this.setFileExtensions(new String[]{"md"});
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        switch (file.getName()) {
            case "README.md": {
                this.checkReadMe(fileText);
            }
        }
    }

    private void checkReadMe(FileText fileText) {
        MutableDataSet options = new MutableDataSet();
        options.set(Parser.TRACK_DOCUMENT_LINES, (Object)true);
        Node readmeMarkdownNode = this.parseMarkdown(fileText, options);
        MarkdownVisitorCallback callBack = new MarkdownVisitorCallback(){

            @Override
            public void log(int line, String message) {
                MarkdownCheck.this.log(line + 1, message, new Object[0]);
            }
        };
        MarkdownVisitor visitor = new MarkdownVisitor(callBack, fileText);
        visitor.visit(readmeMarkdownNode);
    }
}

