/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.openhab.tools.analysis.utils.ContentReceviedCallback;

public class CachingHttpClient<T> {
    private static final int RETRY_TIME = 10;
    private static Cache<URL, Optional<byte[]>> cache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();
    private ContentReceviedCallback<T> callback;

    public CachingHttpClient(ContentReceviedCallback<T> callback) {
        this.callback = callback;
    }

    public synchronized T get(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("URL must not be null");
        }
        Optional content = Optional.empty();
        try {
            content = (Optional)cache.get((Object)url, () -> Optional.of(this.getContent(url)));
        }
        catch (ExecutionException e) {
            cache.put((Object)url, Optional.empty());
            throw new IOException("Unable to get " + url.toString(), e.getCause());
        }
        return content.isPresent() ? (T)this.callback.transform((byte[])content.get()) : null;
    }

    /*
     * Loose catch block
     */
    private byte[] getContent(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            byte[] byArray;
            ByteArrayOutputStream output;
            InputStream input;
            block16: {
                block15: {
                    input = connection.getInputStream();
                    output = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)input, (OutputStream)output);
                    byArray = output.toByteArray();
                    if (output == null) break block15;
                    output.close();
                }
                if (input == null) break block16;
                input.close();
            }
            return byArray;
            {
                catch (Throwable throwable2) {
                    try {
                        if (output != null) {
                            output.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (input != null) {
                            input.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

