/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.pde.core.build.IBuildEntry;
import org.openhab.tools.analysis.checkstyle.api.AbstractExternalLibrariesCheck;

public class BuildPropertiesExternalLibrariesCheck
extends AbstractExternalLibrariesCheck {
    private static final String BIN_INCLUDES = "bin.includes";
    private static final String FILES_NEED_TO_BE_IN_A_LIB_FOLDER = "All jar files need to be placed inside a lib folder.";
    private static final String JAR_PRESENT_IN_BUILD_PROPERTIES_NOT_IN_LIB = "The file %s is present in the build properties but not in the lib folder.";
    private static final String JAR_PRESENT_IN_LIB_NOT_IN_BUILD_PROPERTIES = "The jar file %s is present in the lib folder but is not present in the build properties";
    private static final Log logger = LogFactory.getLog(BuildPropertiesExternalLibrariesCheck.class);

    public BuildPropertiesExternalLibrariesCheck() {
        this.setFileExtensions(new String[]{"properties"});
    }

    private List<String> getBuildPropertiesJarFiles(FileText buildProperties) {
        ArrayList<String> buildPropertiesJarFiles = new ArrayList<String>();
        try {
            for (String token : this.getBinIncludesTokens(buildProperties)) {
                if (!token.contains(".jar")) continue;
                buildPropertiesJarFiles.add(token.trim());
            }
        }
        catch (IOException e) {
            logger.error((Object)"Could not open build properties");
        }
        return buildPropertiesJarFiles;
    }

    private String[] getBinIncludesTokens(FileText buildProperties) throws IOException {
        IBuildEntry binIncludes = null;
        try {
            binIncludes = this.parseBuildProperties(buildProperties).getEntry(BIN_INCLUDES);
        }
        catch (CheckstyleException ex) {
            throw new IOException("Could not open build properties");
        }
        return binIncludes.getTokens();
    }

    private boolean checkIfBuildPropertiesContainsFolder(String[] binIncludesTokens) {
        List<String> tokens = Arrays.asList(binIncludesTokens);
        return tokens.contains("lib/") || tokens.contains("lib/*");
    }

    private boolean checkIfLibFolderExists(File file) {
        File rootFolder = file.getParentFile();
        for (File bundleFile : rootFolder.listFiles()) {
            if (!"lib".equals(bundleFile.getName())) continue;
            return true;
        }
        return false;
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        if (!file.getName().equals("build.properties")) {
            return;
        }
        String rootFolderPath = file.getParentFile().getAbsolutePath();
        File libDirectory = new File(rootFolderPath + File.separator + "lib");
        String[] binIncludes = null;
        try {
            binIncludes = this.getBinIncludesTokens(fileText);
        }
        catch (IOException e) {
            logger.error((Object)"Could not open build properties");
            return;
        }
        boolean containsFolder = this.checkIfBuildPropertiesContainsFolder(binIncludes);
        boolean containsLib = this.checkIfLibFolderExists(file);
        ArrayList<String> libJarFiles = new ArrayList();
        if (containsLib) {
            libJarFiles = this.getLibFolderJarFiles(libDirectory, file.getAbsolutePath());
        }
        if (containsFolder && containsLib) {
            return;
        }
        List<String> buildPropertiesJarFiles = this.getBuildPropertiesJarFiles(fileText);
        if (!(!containsFolder && buildPropertiesJarFiles.isEmpty() || containsLib)) {
            this.log(0, FILES_NEED_TO_BE_IN_A_LIB_FOLDER, new Object[0]);
            return;
        }
        this.checkFiles(buildPropertiesJarFiles, libJarFiles, JAR_PRESENT_IN_BUILD_PROPERTIES_NOT_IN_LIB);
        this.checkFiles(libJarFiles, buildPropertiesJarFiles, JAR_PRESENT_IN_LIB_NOT_IN_BUILD_PROPERTIES);
    }
}

