/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openhab.tools.analysis.checkstyle.api.AbstractEshInfXmlCheck;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class EshInfXmlUsageCheck
extends AbstractEshInfXmlCheck {
    private static final String CONFIG_DESCRIPTION_EXPRESSION = "//config-description[@uri]/@uri";
    private static final String CONFIG_DESCRIPTION_REF_EXPRESSION = "//config-description-ref[@uri]/@uri";
    private static final String BRIDGE_TYPE_EXPRESSION = "//bridge-type[@id]/@id";
    private static final String SUPPORTED_BRIDGE_TYPE_REF_EXPRESSION = "//supported-bridge-type-refs/bridge-type-ref[@id]/@id";
    private static final String MESSAGE_MISSING_URI_CONFIGURATION = "Missing configuration for the configuration reference with uri - {0}";
    private static final String MESSAGE_MISSING_SUPPORTED_BRIDGE = "Missing the supported bridge with id {0}";
    private static final String MESSAGE_UNUSED_URI_CONFIGURATION = "Unused configuration reference with uri - {0}";
    private static final String MESSAGE_UNUSED_BRIDGE = "Unused bridge reference with id - {0}";
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Map<String, File> allConfigDescriptionRefs = new HashMap<String, File>();
    private Map<String, File> allConfigDescriptions = new HashMap<String, File>();
    private Map<String, File> allSupportedBridges = new HashMap<String, File>();
    private Map<String, File> allBridgeTypes = new HashMap<String, File>();

    public void finishProcessing() {
        Map<String, File> missingSupportedBridges = this.removeAll(this.allSupportedBridges, this.allBridgeTypes);
        this.logMissingEntries(missingSupportedBridges, MESSAGE_MISSING_SUPPORTED_BRIDGE);
        Map<String, File> missingConfigDescriptions = this.removeAll(this.allConfigDescriptionRefs, this.allConfigDescriptions);
        this.logMissingEntries(missingConfigDescriptions, MESSAGE_MISSING_URI_CONFIGURATION);
        Map<String, File> unusedBridges = this.removeAll(this.allBridgeTypes, this.allSupportedBridges);
        this.logMissingEntries(unusedBridges, MESSAGE_UNUSED_BRIDGE);
        Map<String, File> unusedConfigDescriptions = this.removeAll(this.allConfigDescriptions, this.allConfigDescriptionRefs);
        this.logMissingEntries(unusedConfigDescriptions, MESSAGE_UNUSED_URI_CONFIGURATION);
    }

    @Override
    protected void checkConfigFile(FileText xmlFileText) throws CheckstyleException {
        this.allConfigDescriptions.putAll(this.evaluateExpressionOnFile(xmlFileText, CONFIG_DESCRIPTION_EXPRESSION));
    }

    @Override
    protected void checkBindingFile(FileText xmlFileText) throws CheckstyleException {
        this.allConfigDescriptionRefs.putAll(this.evaluateExpressionOnFile(xmlFileText, CONFIG_DESCRIPTION_REF_EXPRESSION));
        this.allConfigDescriptions.putAll(this.evaluateExpressionOnFile(xmlFileText, CONFIG_DESCRIPTION_EXPRESSION));
    }

    @Override
    protected void checkThingTypeFile(FileText xmlFileText) throws CheckstyleException {
        this.allSupportedBridges.putAll(this.evaluateExpressionOnFile(xmlFileText, SUPPORTED_BRIDGE_TYPE_REF_EXPRESSION));
        this.allBridgeTypes.putAll(this.evaluateExpressionOnFile(xmlFileText, BRIDGE_TYPE_EXPRESSION));
        this.allConfigDescriptionRefs.putAll(this.evaluateExpressionOnFile(xmlFileText, CONFIG_DESCRIPTION_REF_EXPRESSION));
        this.allConfigDescriptions.putAll(this.evaluateExpressionOnFile(xmlFileText, CONFIG_DESCRIPTION_EXPRESSION));
    }

    private Map<String, File> evaluateExpressionOnFile(FileText xmlFileText, String xPathExpression) throws CheckstyleException {
        HashMap<String, File> collection = new HashMap<String, File>();
        NodeList nodes = this.getNodes(xmlFileText, xPathExpression);
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                collection.put(nodes.item(i).getNodeValue(), xmlFileText.getFile());
            }
        }
        return collection;
    }

    private NodeList getNodes(FileText xmlFileText, String expression) throws CheckstyleException {
        Document document = this.parseDomDocumentFromFile(xmlFileText);
        XPathExpression xpathExpression = this.compileXPathExpression(expression);
        NodeList nodes = null;
        try {
            nodes = (NodeList)xpathExpression.evaluate(document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            String message = MessageFormat.format("Problem occurred while evaluating the expression {0} on the {1} file.", expression, xmlFileText.getFile().getName());
            this.logger.error((Object)message, (Throwable)e);
        }
        return nodes;
    }

    private <K, V> Map<K, V> removeAll(Map<K, V> firstMap, Map<K, V> secondMap) {
        HashMap<K, V> result = new HashMap<K, V>(firstMap);
        result.keySet().removeAll(secondMap.keySet());
        return result;
    }

    private <K> void logMissingEntries(Map<K, File> collection, String message) {
        for (K element : collection.keySet()) {
            File xmlFile = collection.get(element);
            this.logMessage(xmlFile.getPath(), 0, xmlFile.getName(), MessageFormat.format(message, element));
        }
    }
}

