/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.openhab.tools.analysis.checkstyle.api.AbstractEshInfXmlCheck;
import org.openhab.tools.analysis.utils.CachingHttpClient;
import org.openhab.tools.analysis.utils.ContentReceviedCallback;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EshInfXmlValidationCheck
extends AbstractEshInfXmlCheck {
    private static final String MESSAGE_NOT_INCLUDED_XML_FILE = "The file {0} isn't included in the build.properties file. Good approach is to include all files by adding `ESH-INF/` value to the bin.includes property.";
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Map<Path, File> eshInfFiles = new HashMap<Path, File>();
    private IBuild buildPropertiesFile;
    private String thingSchema;
    private String bindingSchema;
    private String configSchema;
    private static Schema thingSchemaFile;
    private static Schema bindingSchemaFile;
    private static Schema configSchemaFile;

    public void setThingSchema(String thingSchema) {
        this.thingSchema = thingSchema;
    }

    public void setBindingSchema(String bindingSchema) {
        this.bindingSchema = bindingSchema;
    }

    public void setConfigSchema(String configSchema) {
        this.configSchema = configSchema;
    }

    public EshInfXmlValidationCheck() {
        this.setFileExtensions(new String[]{"xml", "properties"});
    }

    @Override
    public void beginProcessing(String charset) {
        ContentReceviedCallback<Schema> callback = new ContentReceviedCallback<Schema>(){
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");

            @Override
            public Schema transform(byte[] content) {
                try {
                    ByteArrayInputStream is = new ByteArrayInputStream(content);
                    return this.schemaFactory.newSchema(new StreamSource(is));
                }
                catch (SAXException e) {
                    EshInfXmlValidationCheck.this.logger.error((Object)"Unable to parse schema ", (Throwable)e);
                    return null;
                }
            }
        };
        CachingHttpClient<Schema> cachingClient = new CachingHttpClient<Schema>(callback);
        bindingSchemaFile = this.getXSD(this.bindingSchema, cachingClient);
        thingSchemaFile = this.getXSD(this.thingSchema, cachingClient);
        configSchemaFile = this.getXSD(this.configSchema, cachingClient);
        super.beginProcessing(charset);
    }

    public void finishProcessing() {
        this.checkBuildProperties();
    }

    @Override
    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        this.logger.debug((Object)("Processing the " + file.getName()));
        if (file.getName().equals("build.properties")) {
            this.processBuildProperties(fileText);
        } else {
            super.processFiltered(file, fileText);
        }
    }

    private void checkBuildProperties() {
        if (this.buildPropertiesFile != null) {
            IBuildEntry binIncludes = this.buildPropertiesFile.getEntry("bin.includes");
            if (binIncludes != null) {
                String[] includedTokens;
                for (String included : includedTokens = binIncludes.getTokens()) {
                    Iterator<Map.Entry<Path, File>> it = this.eshInfFiles.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<Path, File> entry = it.next();
                        if (!entry.getKey().startsWith(included)) continue;
                        it.remove();
                    }
                }
            }
            this.logMissingEntries(this.eshInfFiles, MESSAGE_NOT_INCLUDED_XML_FILE);
        }
    }

    @Override
    protected void checkConfigFile(FileText xmlFileText) throws CheckstyleException {
        File xmlFile = xmlFileText.getFile();
        this.addToEshFiles(xmlFile);
        this.validateXmlAgainstSchema(xmlFile, configSchemaFile);
    }

    @Override
    protected void checkBindingFile(FileText xmlFileText) throws CheckstyleException {
        File xmlFile = xmlFileText.getFile();
        this.addToEshFiles(xmlFile);
        this.validateXmlAgainstSchema(xmlFile, bindingSchemaFile);
    }

    @Override
    protected void checkThingTypeFile(FileText xmlFileText) throws CheckstyleException {
        File xmlFile = xmlFileText.getFile();
        this.addToEshFiles(xmlFile);
        this.validateXmlAgainstSchema(xmlFile, thingSchemaFile);
    }

    private void processBuildProperties(FileText fileText) throws CheckstyleException {
        try {
            this.buildPropertiesFile = this.parseBuildProperties(fileText);
        }
        catch (CheckstyleException e) {
            this.logger.error((Object)("Problem occurred while parsing the file " + fileText.getFile().getPath()), (Throwable)e);
        }
    }

    private void validateXmlAgainstSchema(File xmlFile, Schema schema) {
        if (schema != null) {
            try {
                Validator validator = schema.newValidator();
                validator.validate(new StreamSource(xmlFile));
            }
            catch (SAXParseException exception) {
                String message = exception.getMessage();
                message = message.substring(message.indexOf(":") + 2);
                int lineNumber = exception.getLineNumber();
                this.log(lineNumber, message, new Object[]{xmlFile.getPath()});
            }
            catch (IOException | SAXException e) {
                this.logger.error((Object)("Problem occurred while parsing the file " + xmlFile.getName()), (Throwable)e);
            }
        } else {
            this.logger.warn((Object)"XML validation will be skipped as the schema file download failed.");
        }
    }

    private <K> void logMissingEntries(Map<K, File> collection, String message) {
        for (K element : collection.keySet()) {
            File xmlFile = collection.get(element);
            this.logMessage(xmlFile.getPath(), 0, xmlFile.getName(), MessageFormat.format(message, element));
        }
    }

    private void addToEshFiles(File xmlFile) {
        Path filePath = xmlFile.toPath();
        Path bundlePath = filePath.getParent().getParent().getParent();
        Path relativePath = bundlePath.relativize(filePath);
        this.eshInfFiles.put(relativePath, xmlFile);
    }

    private Schema getXSD(String schemaUrlString, CachingHttpClient<Schema> client) {
        try {
            URL schemaUrl = new URL(schemaUrlString);
            return client.get(schemaUrl);
        }
        catch (IOException e) {
            String message = MessageFormat.format("Unable to get XSD file {0} : {1}", schemaUrlString, e.getMessage());
            this.logger.error((Object)message, (Throwable)e);
            return null;
        }
    }
}

