/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Optional;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.util.Version;
import org.openhab.tools.analysis.checkstyle.api.AbstractStaticCheck;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class PomXmlCheck
extends AbstractStaticCheck {
    private static final String MISSING_VERSION_MSG = "Missing /project/version in the pom.xml file.";
    private static final String MISSING_ARTIFACT_ID_MSG = "Missing /project/artifactId in the pom.xml file.";
    private static final String WRONG_VERSION_MSG = "Wrong /project/parent/version in the pom.xml file. The version should match the one in the MANIFEST.MF file.";
    private static final String WRONG_ARTIFACT_ID_MSG = "Wrong /project/artifactId in the pom.xml file. The artifactId should match the bundle symbolic name in the MANIFEST.MF file.";
    private static final String MISSING_PARENT_ARTIFACT_ID_MSG = "Missing /project/parent/artifactId of the parent pom";
    private static final String WRONG_PARENT_ARTIFACT_ID_MSG = "Wrong /project/parent/artifactId. Expected {0} but was {1}";
    private static final String POM_ARTIFACT_ID_XPATH_EXPRESSION = "/project/artifactId/text()";
    private static final String POM_PARENT_ARTIFACT_ID_XPATH_EXPRESSION = "/project/parent/artifactId/text()";
    private static final String POM_PARENT_VERSION_XPATH_EXPRESSION = "/project/parent/version/text()";
    private static final String POM_VERSION_XPATH_EXPRESSION = "/project/version/text()";
    private static final String DIFFERENT_POM_VERSION = "The pom version is different from the parent pom version";
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String pomDirectoryPath;
    private String pomVersion;
    private int pomVersionLine;
    private String manifestVersion;
    private String pomArtifactId;
    private int pomArtifactIdLine;
    private String manifestBundleSymbolicName;
    private Document parentPomXmlDocument;
    private String parentPomPath;
    private String pomPath;
    private boolean checkPomVersion;

    public void setCheckPomVersion(boolean value) {
        this.checkPomVersion = value;
    }

    public PomXmlCheck() {
        this.setFileExtensions(new String[]{"xml", "MF"});
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        String fileName = file.getName();
        if (fileName.equals("pom.xml")) {
            this.processPomXmlFile(fileText);
        } else if (fileName.equals("MANIFEST.MF")) {
            this.processManifestFile(fileText);
        }
    }

    private void processManifestFile(FileText fileText) throws CheckstyleException {
        BundleInfo bundleInfo = this.parseManifestFromFile(fileText);
        Version version = bundleInfo.getVersion();
        this.manifestVersion = version.withoutQualifier().toString();
        if (this.manifestVersion == null) {
            this.log(0, "Manifest version is missing", new Object[0]);
        }
        this.manifestBundleSymbolicName = bundleInfo.getSymbolicName();
    }

    private void processPomXmlFile(FileText fileText) throws CheckstyleException {
        File file = fileText.getFile();
        this.pomPath = file.getPath();
        File pomDirectory = file.getParentFile();
        Document pomXmlDocument = this.parseDomDocumentFromFile(fileText);
        String pomXmlPath = fileText.getFile().getPath();
        this.pomDirectoryPath = pomDirectory.getPath();
        File parentPom = new File(pomDirectory.getParentFile(), "pom.xml");
        this.getPomVersion(pomXmlDocument, pomXmlPath).ifPresent(value -> {
            this.pomVersion = value;
            String versionTagName = "version";
            String versionLine = String.format("<%s>%s</%s>", versionTagName, value, versionTagName);
            this.pomVersionLine = this.findLineNumberSafe(fileText, versionLine, 0, "Pom version line number not found");
        });
        this.getNodeValue(pomXmlDocument, POM_ARTIFACT_ID_XPATH_EXPRESSION, pomXmlPath).ifPresent(value -> {
            this.pomArtifactId = value;
            String artifactIdTagName = "artifactId";
            String artifactIdLine = String.format("<%s>%s</%s>", artifactIdTagName, value, artifactIdTagName);
            this.pomArtifactIdLine = this.findLineNumberSafe(fileText, artifactIdLine, 0, "Pom artifact ID line number not found");
        });
        if (parentPom.exists()) {
            Optional<Document> maybeDocument = this.getParsedPom(parentPom);
            if (!maybeDocument.isPresent()) {
                return;
            }
            this.parentPomXmlDocument = maybeDocument.get();
            this.parentPomPath = parentPom.getPath();
            Optional<String> maybeParentArtifactIdValue = this.getNodeValue(pomXmlDocument, POM_PARENT_ARTIFACT_ID_XPATH_EXPRESSION, pomXmlPath);
            Optional<String> maybeParentPomArtifactIdValue = this.getNodeValue(this.parentPomXmlDocument, POM_ARTIFACT_ID_XPATH_EXPRESSION, this.parentPomPath);
            if (maybeParentArtifactIdValue.isPresent() && maybeParentPomArtifactIdValue.isPresent()) {
                String parentArtifactIdValue;
                String parentPomArtifactIdValue = maybeParentArtifactIdValue.get();
                if (!parentPomArtifactIdValue.equals(parentArtifactIdValue = maybeParentPomArtifactIdValue.get())) {
                    int parentArtifactTagLine = this.findLineNumberSafe(fileText, "parent", 0, "Parent line number not found.");
                    int parentArtifactIdLine = this.findLineNumberSafe(fileText, "artifactId", parentArtifactTagLine, "Parent artifact ID line number not found.");
                    String formattedMessage = MessageFormat.format(WRONG_PARENT_ARTIFACT_ID_MSG, parentArtifactIdValue, parentPomArtifactIdValue);
                    this.log(parentArtifactIdLine, formattedMessage, new Object[]{file.getPath()});
                }
            } else {
                this.log(0, MISSING_PARENT_ARTIFACT_ID_MSG, new Object[]{file.getPath()});
            }
        }
    }

    public void finishProcessing() {
        this.compareProperties(this.pomVersion, this.manifestVersion, this.pomVersionLine, WRONG_VERSION_MSG, MISSING_VERSION_MSG);
        this.compareProperties(this.pomArtifactId, this.manifestBundleSymbolicName, this.pomArtifactIdLine, WRONG_ARTIFACT_ID_MSG, MISSING_ARTIFACT_ID_MSG);
        if (this.checkPomVersion) {
            try {
                this.checkVersions();
            }
            catch (CheckstyleException e) {
                this.logger.error((Object)"An error occurred while processing poms", (Throwable)e);
            }
        }
    }

    private Optional<String> getPomVersion(Document pomXmlDocument, String filePath) throws CheckstyleException {
        Optional<String> maybeVersionNodeValue = this.getNodeValue(pomXmlDocument, POM_VERSION_XPATH_EXPRESSION, filePath);
        if (!maybeVersionNodeValue.isPresent()) {
            return this.getNodeValue(pomXmlDocument, POM_PARENT_VERSION_XPATH_EXPRESSION, filePath);
        }
        return maybeVersionNodeValue;
    }

    private void checkVersions() throws CheckstyleException {
        if (this.parentPomXmlDocument != null) {
            this.getPomVersion(this.parentPomXmlDocument, this.parentPomPath).ifPresent(value -> {
                if (!value.equals(this.pomVersion)) {
                    this.logMessage(this.pomPath, 0, "pom.xml", DIFFERENT_POM_VERSION);
                }
            });
        }
    }

    private void compareProperties(String pomProperty, String manifestProperty, int wrongPropertyLine, String wrongPropertyMessage, String missingPropertyMessage) {
        if (pomProperty != null) {
            if (manifestProperty != null && !pomProperty.contains(manifestProperty)) {
                this.logMessage(this.pomDirectoryPath + File.separator + "pom.xml", wrongPropertyLine, "pom.xml", wrongPropertyMessage);
            }
        } else {
            this.logMessage(this.pomDirectoryPath + File.separator + "pom.xml", 0, "pom.xml", missingPropertyMessage);
        }
    }

    private Optional<String> getNodeValue(Document xmlDocument, String versionExpression, String filePath) throws CheckstyleException {
        XPathExpression xPathExpression = this.compileXPathExpression(versionExpression);
        try {
            Object result = xPathExpression.evaluate(xmlDocument, XPathConstants.NODESET);
            NodeList nodes = (NodeList)result;
            return nodes.getLength() > 0 ? Optional.of(nodes.item(0).getTextContent()) : Optional.empty();
        }
        catch (XPathExpressionException e) {
            this.logger.error((Object)("An exception was thrown, while trying to parse the file: " + filePath), (Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<Document> getParsedPom(File pom) throws CheckstyleException {
        FileText parentPomFileText = null;
        try {
            parentPomFileText = new FileText(pom, "UTF-8");
        }
        catch (IOException e) {
            this.logger.error((Object)"Error in reading the file", (Throwable)e);
        }
        return Optional.ofNullable(this.parseDomDocumentFromFile(parentPomFileText));
    }
}

