/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openhab.tools.analysis.checkstyle.api.AbstractStaticCheck;

public class RequireBundleCheck
extends AbstractStaticCheck {
    private final Log logger = LogFactory.getLog(RequireBundleCheck.class);
    private List<String> allowedRequireBundles = Collections.emptyList();

    public RequireBundleCheck() {
        this.setFileExtensions(new String[]{"MF"});
    }

    public void setAllowedRequireBundles(String[] bundles) {
        this.allowedRequireBundles = Arrays.asList(bundles);
    }

    protected void processFiltered(File file, FileText fileText) {
        block6: {
            try {
                String[] bundleNames;
                String requireBundleHeaderValue;
                Manifest manifest = new Manifest(new FileInputStream(file));
                Attributes attributes = manifest.getMainAttributes();
                String fragmentHost = attributes.getValue("Fragment-Host");
                String bundleSymbolicName = attributes.getValue("Bundle-SymbolicName");
                boolean testBundle = false;
                if (StringUtils.isNotBlank((String)fragmentHost) && StringUtils.isNotBlank((String)bundleSymbolicName)) {
                    boolean bl = testBundle = bundleSymbolicName.startsWith(fragmentHost) && bundleSymbolicName.substring(fragmentHost.length()).startsWith(".test");
                }
                if ((requireBundleHeaderValue = attributes.getValue("Require-Bundle")) != null && !testBundle) {
                    int lineNumber = this.findLineNumberSafe(fileText, requireBundleHeaderValue, 0, "Require-Bundle header line number not found.");
                    this.log(lineNumber, "The MANIFEST.MF file must not contain any Require-Bundle entries. Instead, Import-Package must be used.", new Object[0]);
                    break block6;
                }
                if (requireBundleHeaderValue == null || !testBundle) break block6;
                for (String bundleName : bundleNames = requireBundleHeaderValue.split(",")) {
                    if (this.allowedRequireBundles.contains(bundleName)) continue;
                    int lineNumber = this.findLineNumberSafe(fileText, requireBundleHeaderValue, 0, "Header value not found.");
                    this.log(lineNumber, "The MANIFEST.MF file of a test fragment must not contain Require-Bundle entries other than " + this.getAllowedBundlesString() + ".", new Object[0]);
                    break;
                }
            }
            catch (FileNotFoundException e) {
                this.logger.error((Object)("An exception was thrown while trying to open the file " + file.getPath()), (Throwable)e);
            }
            catch (IOException e) {
                this.logger.error((Object)("An exception was thrown while trying to read the file " + file.getPath()), (Throwable)e);
            }
        }
    }

    private String getAllowedBundlesString() {
        StringBuilder sb = new StringBuilder();
        for (String bundleName : this.allowedRequireBundles) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(bundleName);
        }
        return sb.toString();
    }
}

