/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.text.MessageFormat;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openhab.tools.analysis.checkstyle.api.AbstractStaticCheck;

public abstract class AbstractEshInfXmlCheck
extends AbstractStaticCheck {
    public static final String THING_DIRECTORY = "thing";
    public static final String BINDING_DIRECTORY = "binding";
    public static final String CONFIGURATION_DIRECTORY = "config";
    private static final String MESSAGE_EMPTY_FILE = "The file {0} should not be empty.";
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public AbstractEshInfXmlCheck() {
        this.setFileExtensions(new String[]{"xml"});
    }

    public void beginProcessing(String charset) {
        this.logger.debug((Object)("Executing the " + ((Object)((Object)this)).getClass().getSimpleName()));
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        String fileName = file.getName();
        if (FilenameUtils.getExtension((String)fileName).equals("xml")) {
            this.processXmlFile(fileText);
        }
    }

    private void processXmlFile(FileText xmlFileText) throws CheckstyleException {
        File xmlFile = xmlFileText.getFile();
        if (this.isEmpty(xmlFileText)) {
            this.log(0, MessageFormat.format(MESSAGE_EMPTY_FILE, xmlFile.getName()), new Object[]{xmlFile.getPath()});
        } else {
            File fileParentDirectory = xmlFile.getParentFile();
            boolean isESHParentDirectory = "ESH-INF".equals(fileParentDirectory.getParentFile().getName());
            if (isESHParentDirectory) {
                switch (fileParentDirectory.getName()) {
                    case "thing": {
                        this.checkThingTypeFile(xmlFileText);
                        break;
                    }
                    case "binding": {
                        this.checkBindingFile(xmlFileText);
                        break;
                    }
                    case "config": {
                        this.checkConfigFile(xmlFileText);
                        break;
                    }
                }
            }
        }
    }

    protected abstract void checkConfigFile(FileText var1) throws CheckstyleException;

    protected abstract void checkBindingFile(FileText var1) throws CheckstyleException;

    protected abstract void checkThingTypeFile(FileText var1) throws CheckstyleException;
}

