/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle.readme;

import com.puppycrawl.tools.checkstyle.api.FileText;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.ListBlock;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.NodeVisitorBase;
import com.vladsch.flexmark.ast.Paragraph;
import org.apache.commons.lang.StringUtils;
import org.openhab.tools.analysis.checkstyle.readme.MarkdownVisitorCallback;

class MarkdownVisitor
extends NodeVisitorBase {
    private static final String EMPTY_LINE_AFTER_HEADER_MSG = "Missing an empty line after the Markdown header ('#').";
    private static final String EMPTY_LINE_BEFORE_LIST_MSG = "The line before a Markdown list must be empty.";
    private static final String EMPTY_LINE_AFTER_LIST_MSG = "The line after a Markdown list must be empty.";
    private static final String EMPTY_LINE_BEFORE_CODE_MSG = "The line before code formatting section must be empty.";
    private static final String EMPTY_LINE_AFTER_CODE_MSG = "The line after code formatting section must be empty.";
    private static final String EMPTY_CODE_BLOCK_WARNING = "There is an empty or unclosed code formatting section. Please correct it.";
    private static final String HEADER_AT_END_OF_FILE = "There is a header at the end of the Markdown file. Please consider adding some content below.";
    private static final String REGEX_NEW_LINES = "\\\r?\\\n";
    private MarkdownVisitorCallback callback;
    private FileText fileText;

    public MarkdownVisitor(MarkdownVisitorCallback callBack, FileText fileText) {
        this.callback = callBack;
        this.fileText = fileText;
    }

    public void visit(Heading heading) {
        this.validateHeadingPosition(heading.getEndLineNumber());
    }

    private void validateHeadingPosition(int zeroBasedHeaderLineNumber) {
        boolean isHeaderAtEndOfFile;
        boolean bl = isHeaderAtEndOfFile = zeroBasedHeaderLineNumber == this.fileText.size() - 1;
        if (isHeaderAtEndOfFile) {
            this.callback.log(zeroBasedHeaderLineNumber, HEADER_AT_END_OF_FILE);
        } else {
            boolean isNextLineEmpty = StringUtils.isBlank((String)this.fileText.get(zeroBasedHeaderLineNumber + 1));
            if (!isNextLineEmpty) {
                this.callback.log(zeroBasedHeaderLineNumber, EMPTY_LINE_AFTER_HEADER_MSG);
            }
        }
    }

    public void visit(FencedCodeBlock fencedCodeBlock) {
        this.validateCodeSectionPosition(fencedCodeBlock.getLineNumber(), fencedCodeBlock.getEndLineNumber(), (Node)fencedCodeBlock);
    }

    private void validateCodeSectionPosition(int zeroBasedStartLineNumber, int zeroBasedEndLineNumber, Node codeBlockText) {
        Node codeSection = codeBlockText.getFirstChild();
        if (codeSection != null && !StringUtils.isBlank((String)codeSection.getChars().toString())) {
            if (zeroBasedStartLineNumber == 0 || !StringUtils.isBlank((String)this.fileText.get(zeroBasedStartLineNumber - 1))) {
                this.callback.log(zeroBasedStartLineNumber, EMPTY_LINE_BEFORE_CODE_MSG);
            }
            if (zeroBasedEndLineNumber != this.fileText.size() - 1 && !StringUtils.isBlank((String)this.fileText.get(zeroBasedEndLineNumber + 1))) {
                this.callback.log(zeroBasedEndLineNumber, EMPTY_LINE_AFTER_CODE_MSG);
            }
        } else {
            this.callback.log(zeroBasedStartLineNumber, EMPTY_CODE_BLOCK_WARNING);
        }
    }

    private void processListBlock(ListBlock listBlock) {
        this.checkEmptyLineBefore(listBlock);
        this.checkEmptyLineAfterList(listBlock);
    }

    private void checkEmptyLineBefore(ListBlock listBlock) {
        boolean isListfirstLineInFile;
        int firstLineOfList = listBlock.getLineNumber();
        boolean isInnerList = listBlock.getParent() instanceof ListItem;
        if (isInnerList) {
            return;
        }
        boolean bl = isListfirstLineInFile = firstLineOfList == 0;
        if (isListfirstLineInFile || !StringUtils.isBlank((String)this.fileText.get(firstLineOfList - 1))) {
            this.callback.log(firstLineOfList, EMPTY_LINE_BEFORE_LIST_MSG);
        }
    }

    private void checkEmptyLineAfterList(ListBlock listBlock) {
        String[] lastListItemlines;
        ListItem lastListItem = (ListItem)listBlock.getLastChild();
        Node lastListItemContent = lastListItem.getLastChild();
        boolean isListEnd = lastListItemContent instanceof Paragraph;
        if (isListEnd && (lastListItemlines = lastListItemContent.getChars().toString().split(REGEX_NEW_LINES)).length > 1) {
            this.callback.log(lastListItemContent.getLineNumber(), EMPTY_LINE_AFTER_LIST_MSG);
        }
    }

    public void visit(ListBlock list) {
        list.getChildIterator().forEachRemaining(listItem -> this.visit((Node)listItem));
        this.processListBlock(list);
    }

    protected void visit(Node node) {
        if (node instanceof FencedCodeBlock) {
            this.visit((FencedCodeBlock)node);
        } else if (node instanceof Heading) {
            this.visit((Heading)node);
        } else if (node instanceof ListBlock) {
            this.visit((ListBlock)node);
        } else {
            this.visitChildren(node);
        }
    }
}

