/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;

public class CustomClassNameLengthDetector
implements Detector {
    private static final int ARBITRARY_MAX_CLASS_NAME_LENGTH = 50;
    private final BugReporter bugReporter;

    public CustomClassNameLengthDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void report() {
    }

    public void visitClassContext(ClassContext classContext) {
        int classNameLength = classContext.getClassDescriptor().getSimpleName().length();
        if (classNameLength > 50) {
            this.bugReporter.reportBug(new BugInstance("CLASS_NAME_LENGTH", 2));
        }
    }
}

