/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.pmd;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class UseSLF4JLoggerRule
extends AbstractJavaRule {
    private static final String LOGGER_LITERAL = "Logger";
    private Set<String> forbiddenLoggers = new HashSet<String>();
    private boolean isSlf4jPackageImported;

    public UseSLF4JLoggerRule() {
        this.forbiddenLoggers.add("org.apache.log4j.Logger");
        this.forbiddenLoggers.add("java.util.logging.Logger");
        this.forbiddenLoggers.add("ch.qos.logback.classic.Logger");
        this.forbiddenLoggers.add("org.apache.commons.logging.Log");
    }

    public Object visit(ASTImportDeclaration node, Object data) {
        String fullImportName = node.getImportedName();
        if (this.forbiddenLoggers.contains(fullImportName)) {
            this.addViolation(data, (Node)node);
        } else if ("org.slf4j.Logger".equals(fullImportName) || "org.slf4j".equals(fullImportName) && node.isImportOnDemand()) {
            this.isSlf4jPackageImported = true;
        }
        return super.visit(node, data);
    }

    public Object visit(ASTVariableDeclarator node, Object data) {
        String className;
        ASTClassOrInterfaceType classOrInterfaceType;
        Node reftypeNode;
        ASTType typeNode = (ASTType)((JavaNode)node.getParent()).getFirstChildOfType(ASTType.class);
        if (typeNode != null && (reftypeNode = typeNode.getChild(0)) instanceof ASTReferenceType && (classOrInterfaceType = (ASTClassOrInterfaceType)reftypeNode.getFirstChildOfType(ASTClassOrInterfaceType.class)) != null && this.isClassNameForbidden(className = classOrInterfaceType.getImage())) {
            this.addViolation(data, (Node)typeNode);
        }
        return super.visit(node, data);
    }

    private boolean isClassNameForbidden(String className) {
        if (this.forbiddenLoggers.contains(className)) {
            return true;
        }
        return LOGGER_LITERAL.equals(className) && !this.isSlf4jPackageImported;
    }
}

