/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.report;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.openhab.tools.analysis.report.ReportUtil;

@Component(role=SummaryReportHtmlGenerator.class)
public class SummaryReportHtmlGenerator {
    @Requirement
    private Logger logger;
    private TransformerFactory transformerFactory;
    private ClassLoader contextClassLoader;

    void initialize() {
        this.contextClassLoader = Thread.currentThread().getContextClassLoader();
        this.transformerFactory = TransformerFactory.newInstance(TransformerFactoryImpl.class.getName(), this.contextClassLoader);
    }

    File generateHtmlSummaryByRules(String summaryReportDirectory) {
        File latestMergeResult = new File(summaryReportDirectory, "merge.xml");
        File latestMergeResultCopy = new File(summaryReportDirectory, "summary.xml");
        try {
            ReportUtil.acquireMergeLock();
            if (!latestMergeResult.exists()) {
                File file = null;
                return file;
            }
            ReportUtil.acquireSummaryLock();
            Files.copy(latestMergeResult.toPath(), latestMergeResultCopy.toPath(), StandardCopyOption.REPLACE_EXISTING);
            ReportUtil.releaseMergeLock();
            File latestSummaryReport = new File(summaryReportDirectory, "summary_report.html");
            this.run("report/create_html.xslt", latestMergeResultCopy, latestSummaryReport);
            if (!latestMergeResultCopy.delete()) {
                this.logger.error("Unable to delete file: " + latestMergeResultCopy.getAbsolutePath());
            }
            File file = latestSummaryReport;
            return file;
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception while copying latest merge result", e);
        }
        finally {
            ReportUtil.releaseMergeLock();
            ReportUtil.releaseSummaryLock();
        }
    }

    private void run(String xslt, File input, File output) {
        try (FileOutputStream outputStream = new FileOutputStream(output);
             InputStream inputStream = this.contextClassLoader.getResourceAsStream(xslt);
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format("{0}  > {1} >  {2}", input, xslt, output));
            }
            StreamSource source = new StreamSource(reader);
            Transformer transformer = this.transformerFactory.newTransformer(source);
            StreamResult outputTarget = new StreamResult(outputStream);
            StreamSource xmlSource = new StreamSource(input);
            Instant start = Instant.now();
            transformer.transform(xmlSource, outputTarget);
            Instant end = Instant.now();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(MessageFormat.format("Transformation ''{0}'' took {1}ms", xslt, Duration.between(start, end).toMillis()));
            }
        }
        catch (IOException e) {
            this.logger.error("IOException occurred", (Throwable)e);
        }
        catch (TransformerException e) {
            this.logger.error("TransformerException occurred", (Throwable)e);
        }
    }
}

