/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.report;

import java.io.File;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.openhab.tools.analysis.report.ReportUtil;
import org.openhab.tools.analysis.report.SummaryHtmlGeneration;
import org.openhab.tools.analysis.report.SummaryReportHtmlGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=SummaryReportExecutionListener.class)
public class SummaryReportExecutionListener
extends AbstractExecutionListener {
    private Logger logger = LoggerFactory.getLogger(SummaryReportExecutionListener.class);
    @Requirement
    private SummaryReportHtmlGenerator summaryReportHtmlGenerator;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private ExecutionListener listener;
    private final Map<String, SummaryUpdater> summaryUpdaters = Collections.synchronizedMap(new HashMap());

    public void chainListener(MavenSession session) {
        this.listener = session.getRequest().getExecutionListener();
        session.getRequest().setExecutionListener((ExecutionListener)this);
    }

    private void generateSummaryReportForExecution(ExecutionEvent event) {
        try {
            this.getOrCreateSummaryUpdater(event).incrementalUpdate();
        }
        catch (ExpressionEvaluationException e) {
            this.logger.error("Exception while evaluating '{}' plugin parameter", (Object)"summaryReportDirectory", (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SummaryUpdater getOrCreateSummaryUpdater(ExecutionEvent event) throws ExpressionEvaluationException {
        SummaryUpdater summaryUpdater;
        String directory = this.getPluginParameterValue(event, "summaryReportDirectory");
        Map<String, SummaryUpdater> map = this.summaryUpdaters;
        synchronized (map) {
            summaryUpdater = this.summaryUpdaters.get(directory);
            if (summaryUpdater == null) {
                SummaryHtmlGeneration htmlGeneration = SummaryHtmlGeneration.valueOf((String)this.getPluginParameterValue(event, "summaryHtmlGeneration").toUpperCase());
                int htmlGenerationPeriod = Integer.parseInt(this.getPluginParameterValue(event, "summaryHtmlGenerationPeriod"));
                summaryUpdater = new SummaryUpdater(directory, htmlGeneration, htmlGenerationPeriod);
                this.summaryUpdaters.put(directory, summaryUpdater);
            }
        }
        return summaryUpdater;
    }

    private String getPluginParameterValue(ExecutionEvent event, String parameterName) throws ExpressionEvaluationException {
        Parameter parameter = (Parameter)event.getMojoExecution().getMojoDescriptor().getParameterMap().get(parameterName);
        PluginParameterExpressionEvaluator evaluator = this.getEvaluator(event);
        String parameterValue = (String)evaluator.evaluate(parameter.getExpression());
        if (parameterValue == null) {
            parameterValue = (String)evaluator.evaluate(parameter.getDefaultValue());
        }
        return parameterValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateFinalSummaryReports() {
        Map<String, SummaryUpdater> map = this.summaryUpdaters;
        synchronized (map) {
            this.summaryUpdaters.values().forEach(SummaryUpdater::finalUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginParameterExpressionEvaluator getEvaluator(ExecutionEvent event) {
        PluginParameterExpressionEvaluator evaluator;
        MavenSession session = event.getSession();
        MavenProject currentProject = session.getCurrentProject();
        MavenSession mavenSession = session;
        synchronized (mavenSession) {
            session.setCurrentProject(event.getProject());
            evaluator = new PluginParameterExpressionEvaluator(session, event.getMojoExecution());
            session.setCurrentProject(currentProject);
        }
        return evaluator;
    }

    public void projectDiscoveryStarted(ExecutionEvent event) {
        this.listener.projectDiscoveryStarted(event);
    }

    public void sessionStarted(ExecutionEvent event) {
        this.listener.sessionStarted(event);
    }

    public void sessionEnded(ExecutionEvent event) {
        this.listener.sessionEnded(event);
    }

    public void projectSkipped(ExecutionEvent event) {
        this.listener.projectSkipped(event);
    }

    public void projectStarted(ExecutionEvent event) {
        this.listener.projectStarted(event);
    }

    public void projectSucceeded(ExecutionEvent event) {
        this.listener.projectSucceeded(event);
    }

    public void projectFailed(ExecutionEvent event) {
        this.listener.projectFailed(event);
    }

    public void forkStarted(ExecutionEvent event) {
        this.listener.forkStarted(event);
    }

    public void forkSucceeded(ExecutionEvent event) {
        this.listener.forkSucceeded(event);
    }

    public void forkFailed(ExecutionEvent event) {
        this.listener.forkFailed(event);
    }

    public void mojoSkipped(ExecutionEvent event) {
        this.listener.mojoSkipped(event);
    }

    public void mojoStarted(ExecutionEvent event) {
        this.listener.mojoStarted(event);
    }

    public void mojoSucceeded(ExecutionEvent event) {
        this.listener.mojoSucceeded(event);
        if (ReportUtil.isReportExecution((ExecutionEvent)event)) {
            this.generateSummaryReportForExecution(event);
        }
    }

    public void mojoFailed(ExecutionEvent event) {
        this.listener.mojoFailed(event);
    }

    public void forkedProjectStarted(ExecutionEvent event) {
        this.listener.forkedProjectStarted(event);
    }

    public void forkedProjectSucceeded(ExecutionEvent event) {
        this.listener.forkedProjectSucceeded(event);
    }

    public void forkedProjectFailed(ExecutionEvent event) {
        this.listener.forkedProjectFailed(event);
    }

    static /* synthetic */ Logger access$0(SummaryReportExecutionListener summaryReportExecutionListener) {
        return summaryReportExecutionListener.logger;
    }

    private class SummaryUpdater {
        private final String directory;
        private final SummaryHtmlGeneration htmlGeneration;
        private final int htmlGenerationPeriod;
        private Instant lastUpdate = Instant.MIN;

        public SummaryUpdater(String directory, SummaryHtmlGeneration htmlGeneration, int htmlGenerationPeriod) {
            this.directory = directory;
            this.htmlGeneration = htmlGeneration;
            this.htmlGenerationPeriod = htmlGenerationPeriod;
        }

        private File update() {
            File latestSummaryReport = SummaryReportExecutionListener.this.summaryReportHtmlGenerator.generateHtmlSummaryByRules(this.directory);
            this.lastUpdate = Instant.now();
            return latestSummaryReport;
        }

        private boolean shouldUpdateIncrementally() {
            return this.htmlGeneration == SummaryHtmlGeneration.CONTINUOUS || this.htmlGeneration == SummaryHtmlGeneration.PERIODIC && Instant.now().isAfter(this.lastUpdate.plusSeconds(this.htmlGenerationPeriod));
        }

        public void incrementalUpdate() {
            if (this.shouldUpdateIncrementally()) {
                SummaryReportExecutionListener.this.executor.submit(() -> {
                    if (this.shouldUpdateIncrementally()) {
                        File latestSummaryReport = this.update();
                        SummaryReportExecutionListener.this.logger.debug("Updated static code analysis summary report in:");
                        SummaryReportExecutionListener.this.logger.debug("{}", (Object)latestSummaryReport.toURI());
                    }
                });
            }
        }

        public void finalUpdate() {
            File latestSummaryReport;
            if (this.htmlGeneration != SummaryHtmlGeneration.NEVER && (latestSummaryReport = this.update()) != null) {
                SummaryReportExecutionListener.this.logger.info("Static code analysis summary report is available in:");
                SummaryReportExecutionListener.this.logger.info("{}", (Object)latestSummaryReport.toURI());
            }
        }
    }
}

