/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.report;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.time.Instant;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.codehaus.plexus.component.annotations.Component;
import org.openhab.tools.analysis.report.ReportUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=SummaryReportHtmlGenerator.class)
public class SummaryReportHtmlGenerator {
    private Logger logger = LoggerFactory.getLogger(SummaryReportHtmlGenerator.class);
    private TransformerFactory transformerFactory;
    private ClassLoader contextClassLoader;

    void initialize() {
        this.contextClassLoader = Thread.currentThread().getContextClassLoader();
        this.transformerFactory = TransformerFactory.newInstance(TransformerFactoryImpl.class.getName(), this.contextClassLoader);
    }

    File generateHtmlSummaryByRules(String summaryReportDirectory) {
        File latestMergeResult = new File(summaryReportDirectory, "merge.xml");
        File latestMergeResultCopy = new File(summaryReportDirectory, "summary.xml");
        try {
            ReportUtil.acquireMergeLock();
            if (!latestMergeResult.exists()) {
                return null;
            }
            ReportUtil.acquireSummaryLock();
            Files.copy(latestMergeResult.toPath(), latestMergeResultCopy.toPath(), StandardCopyOption.REPLACE_EXISTING);
            ReportUtil.releaseMergeLock();
            File latestSummaryReport = new File(summaryReportDirectory, "summary_report.html");
            this.run("report/create_html.xslt", latestMergeResultCopy, latestSummaryReport);
            if (!latestMergeResultCopy.delete()) {
                this.logger.error("Unable to delete file: {}", (Object)latestMergeResultCopy.getAbsolutePath());
            }
            File file = latestSummaryReport;
            return file;
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception while copying latest merge result", e);
        }
        finally {
            ReportUtil.releaseMergeLock();
            ReportUtil.releaseSummaryLock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void run(String xslt, File input, File output) {
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try {
                FileOutputStream outputStream = new FileOutputStream(output);
                try {
                    block21: {
                        InputStream inputStream = this.contextClassLoader.getResourceAsStream(xslt);
                        try {
                            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                                this.logger.debug("{}  > {} >  {}", new Object[]{input, xslt, output});
                                StreamSource source = new StreamSource(reader);
                                Transformer transformer = this.transformerFactory.newTransformer(source);
                                StreamResult outputTarget = new StreamResult(outputStream);
                                StreamSource xmlSource = new StreamSource(input);
                                Instant start = Instant.now();
                                transformer.transform(xmlSource, outputTarget);
                                Instant end = Instant.now();
                                this.logger.debug("Transformation '{}' took {}ms", (Object)xslt, (Object)Duration.between(start, end).toMillis());
                            }
                            if (inputStream == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (inputStream == null) throw throwable;
                            inputStream.close();
                            throw throwable;
                        }
                        inputStream.close();
                    }
                    if (outputStream == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (outputStream == null) throw throwable;
                    outputStream.close();
                    throw throwable;
                }
                outputStream.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException e) {
            this.logger.error("IOException occurred", (Throwable)e);
            return;
        }
        catch (TransformerException e) {
            this.logger.error("TransformerException occurred", (Throwable)e);
        }
    }
}

