/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.report;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.dom4j.dom.DOMNodeHelper;
import org.openhab.tools.analysis.report.ReportUtil;
import org.openhab.tools.analysis.report.SummaryHtmlGeneration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Mojo(name="report", threadSafe=true)
public class ReportMojo
extends AbstractMojo {
    @Parameter(property="report.targetDir", defaultValue="${project.build.directory}/code-analysis")
    private File targetDirectory;
    @Parameter(property="report.fail.on.error", defaultValue="true")
    private boolean failOnError;
    @Parameter(property="report.summary.targetDir", defaultValue="${session.executionRootDirectory}/target")
    private File summaryReportDirectory;
    @Parameter(property="report.in.maven", defaultValue="true")
    private boolean reportInMaven;
    @Parameter(property="report.summary.html.generation", defaultValue="PERIODIC")
    private SummaryHtmlGeneration summaryHtmlGeneration;
    @Parameter(property="report.summary.html.generation.period", defaultValue="60")
    private int summaryHtmlGenerationPeriod;
    private TransformerFactory transformerFactory;

    public void setTargetDirectory(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setSummaryReport(File summaryReport) {
        this.summaryReportDirectory = summaryReport;
    }

    public void setReportInMaven(boolean reportInMaven) {
        this.reportInMaven = reportInMaven;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoFailureException {
        File inputFilePMD;
        File inputFileCheckstyle;
        this.transformerFactory = TransformerFactory.newInstance(TransformerFactoryImpl.class.getName(), Thread.currentThread().getContextClassLoader());
        String timeStamp = Integer.toHexString((int)System.nanoTime());
        LinkedList<File> transformedReports = new LinkedList<File>();
        File inputFileFindbugs = new File(this.targetDirectory, "spotbugsXml.xml");
        if (inputFileFindbugs.exists()) {
            File findbugsTempFile = new File(this.targetDirectory, timeStamp + "_PostFB.xml");
            this.run("report/prepare_findbugs.xslt", inputFileFindbugs, findbugsTempFile, "", null);
            transformedReports.add(findbugsTempFile);
        }
        if ((inputFileCheckstyle = new File(this.targetDirectory, "checkstyle-result.xml")).exists()) {
            File checkstyleTempFile = new File(this.targetDirectory, timeStamp + "_PostCS.xml");
            this.run("report/prepare_checkstyle.xslt", inputFileCheckstyle, checkstyleTempFile, "", null);
            transformedReports.add(checkstyleTempFile);
        }
        if ((inputFilePMD = new File(this.targetDirectory, "pmd.xml")).exists()) {
            File pmdTempFile = new File(this.targetDirectory, timeStamp + "_PostPM.xml");
            this.run("report/prepare_pmd.xslt", inputFilePMD, pmdTempFile, "", null);
            transformedReports.add(pmdTempFile);
        }
        if (!transformedReports.isEmpty()) {
            while (transformedReports.size() != 1) {
                File firstReport = (File)transformedReports.poll();
                File secondReport = (File)transformedReports.poll();
                File mergeResult = new File(this.targetDirectory, timeStamp + "_" + transformedReports.size() + "_Merge.xml");
                this.run("report/merge.xslt", firstReport, mergeResult, "with", secondReport);
                transformedReports.add(mergeResult);
                this.deleteFile(firstReport);
                this.deleteFile(secondReport);
            }
            File htmlOutputFileName = new File(this.targetDirectory, "report.html");
            File mergedReport = (File)transformedReports.poll();
            this.run("report/create_html.xslt", mergedReport, htmlOutputFileName, "", null);
            if (this.summaryReportDirectory != null) {
                this.ensureSummaryReportDirectoryExists();
                ReportUtil.acquireMergeLock();
                try {
                    this.generateSummaryByBundle(htmlOutputFileName, mergedReport);
                    this.generateSummaryByRules(htmlOutputFileName, mergedReport);
                }
                finally {
                    ReportUtil.releaseMergeLock();
                }
            }
            if (this.reportInMaven) {
                this.reportWarningsAndErrors(mergedReport, htmlOutputFileName);
            }
            if (this.failOnError) {
                this.failOnErrors(mergedReport);
            }
            this.deleteFile(mergedReport);
        } else {
            this.getLog().info((CharSequence)"No reports found !");
        }
    }

    private void run(String xslt, File input, File output, String param, File value) {
        try (FileOutputStream outputStream = new FileOutputStream(output);
             InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(xslt);
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)MessageFormat.format("{0}  > {1} {2} {3} >  {4}", input, xslt, param, value, output));
            }
            StreamSource source = new StreamSource(reader);
            Transformer transformer = this.transformerFactory.newTransformer(source);
            if (!param.isEmpty()) {
                transformer.setParameter(param, value.toURI().toURL());
            }
            StreamResult outputTarget = new StreamResult(outputStream);
            StreamSource xmlSource = new StreamSource(input);
            Instant start = Instant.now();
            transformer.transform(xmlSource, outputTarget);
            Instant end = Instant.now();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)MessageFormat.format("Transformation ''{0}'' took {1}ms", xslt, Duration.between(start, end).toMillis()));
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"IOException occurred", (Throwable)e);
        }
        catch (TransformerException e) {
            this.getLog().error((CharSequence)"TransformerException occurred", (Throwable)e);
        }
    }

    private void copyFile(File source, File target) throws IOException {
        Files.copy(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private void deleteFile(File file) {
        if (!file.delete()) {
            this.getLog().error((CharSequence)("Unable to delete file " + file.getAbsolutePath()));
        }
    }

    private void reportWarningsAndErrors(File mergedReport, File reportLocation) {
        NodeList messages = this.selectNodes(mergedReport, "/sca/file/message");
        int messageCount = messages.getLength();
        int errorCount = this.countPriority(messages, "1");
        int warnCount = this.countPriority(messages, "2");
        int infoCount = this.countPriority(messages, "3");
        if (messageCount == 0) {
            return;
        }
        String format = String.format("Code Analysis Tool has found: %n %d error(s)! %n %d warning(s) %n %d info(s)", errorCount, warnCount, infoCount);
        this.report(this.maxLevel(errorCount, warnCount, infoCount), format);
        for (int i = 0; i < messages.getLength(); ++i) {
            Node currentNode = messages.item(i);
            if (currentNode.getNodeType() != 1) continue;
            Element messageNode = (Element)currentNode;
            String priority = messageNode.getAttribute("priority");
            Element fileNode = (Element)messageNode.getParentNode();
            String fileName = fileNode.getAttribute("name");
            String line = messageNode.getAttribute("line");
            String message = messageNode.getAttribute("message").trim();
            String logTemplate = "%s:[%s]%n%s";
            String log = String.format(logTemplate, fileName, line, message);
            this.report(priority, log);
        }
        this.getLog().info((CharSequence)("Detailed report can be found at: " + reportLocation.toURI()));
    }

    private String maxLevel(int errorCount, int warnCount, int infoCount) {
        if (errorCount > 0) {
            return "1";
        }
        if (warnCount > 0) {
            return "2";
        }
        return "3";
    }

    private int countPriority(NodeList messages, String priority) {
        int count = 0;
        for (int i = 0; i < messages.getLength(); ++i) {
            Element messageNode;
            Node currentNode = messages.item(i);
            if (currentNode.getNodeType() != 1 || !priority.equals((messageNode = (Element)currentNode).getAttribute("priority"))) continue;
            ++count;
        }
        return count;
    }

    private void failOnErrors(File mergedReport) throws MojoFailureException {
        int errorCount = this.selectNodes(mergedReport, "/sca/file/message[@priority=1]").getLength();
        if (errorCount > 0) {
            throw new MojoFailureException(String.format("%nCode Analysis Tool has found %d error(s)! %nPlease fix the errors and rerun the build. %n", this.selectNodes(mergedReport, "/sca/file/message[@priority=1]").getLength()));
        }
    }

    private void report(String priority, String log) {
        switch (priority) {
            case "1": {
                this.getLog().error((CharSequence)log);
                break;
            }
            case "2": {
                this.getLog().warn((CharSequence)log);
                break;
            }
            default: {
                this.getLog().debug((CharSequence)log);
            }
        }
    }

    private void ensureSummaryReportDirectoryExists() {
        if (!this.summaryReportDirectory.exists()) {
            this.summaryReportDirectory.mkdirs();
        }
    }

    private void generateSummaryByBundle(File htmlOutputFile, File mergedReport) {
        NodeList nodes = this.selectNodes(mergedReport, "/sca/file/message");
        int messagesNumber = nodes.getLength();
        if (messagesNumber == 0) {
            this.getLog().info((CharSequence)"Empty report will not be appended to the summary report.");
            return;
        }
        try {
            File summaryReport = new File(this.summaryReportDirectory, "summary_bundles.html");
            if (!summaryReport.exists()) {
                InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("report/summary.html");
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)inputStream, (Writer)writer, (Charset)Charset.defaultCharset());
                String htmlString = writer.toString();
                String now = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date());
                htmlString = htmlString.replace("$time", now);
                FileUtils.writeStringToFile((File)summaryReport, (String)htmlString);
            }
            String reportContent = FileUtils.readFileToString((File)summaryReport);
            String singleItem = "<tr class=alternate><td><a href=\"%s\">%s</a></td></tr><tr></tr>";
            Path absoluteIndividualReportPath = htmlOutputFile.toPath();
            Path summaryReportDirectoryPath = this.summaryReportDirectory.toPath();
            Path relativePath = summaryReportDirectoryPath.relativize(absoluteIndividualReportPath);
            String bundleName = absoluteIndividualReportPath.getName(absoluteIndividualReportPath.getNameCount() - 4).toString();
            String row = String.format("<tr class=alternate><td><a href=\"%s\">%s</a></td></tr><tr></tr>", relativePath, bundleName);
            reportContent = reportContent.replace("<tr></tr>", row);
            FileUtils.writeStringToFile((File)summaryReport, (String)reportContent);
            this.getLog().info((CharSequence)"Individual report appended to summary report.");
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Can't read or write to summary report. The summary report might be incomplete!", (Throwable)e);
        }
    }

    private void generateSummaryByRules(File htmlOutputFileName, File mergedReport) {
        File latestMergeResult = new File(this.summaryReportDirectory, "merge.xml");
        File latestSummaryReport = new File(this.summaryReportDirectory, "summary_report.html");
        try {
            if (!latestMergeResult.exists() && !latestSummaryReport.exists()) {
                latestMergeResult.createNewFile();
                latestSummaryReport.createNewFile();
                this.copyFile(mergedReport, latestMergeResult);
                this.copyFile(htmlOutputFileName, latestSummaryReport);
            } else {
                File tempMergedReport = new File(this.summaryReportDirectory, "merge.xml.tmp");
                this.copyFile(latestMergeResult, tempMergedReport);
                this.run("report/merge.xslt", tempMergedReport, latestMergeResult, "with", mergedReport);
                this.deleteFile(tempMergedReport);
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Unable to create or write to file " + e.getMessage()), (Throwable)e);
        }
    }

    private NodeList selectNodes(File file, String xPathExpression) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(file);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression expression = xPath.compile(xPathExpression);
            return (NodeList)expression.evaluate(document, XPathConstants.NODESET);
        }
        catch (Exception e) {
            String message = MessageFormat.format("Can't select {0} nodes from {1}. Empty NodeList will be returned.", xPathExpression, file.getAbsolutePath());
            this.getLog().warn((CharSequence)message, (Throwable)e);
            return new DOMNodeHelper.EmptyNodeList();
        }
    }
}

