/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.openhab.tools.analysis.tools.AbstractChecker;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="pmd", requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class PmdChecker
extends AbstractChecker {
    private static final String DEFAULT_RULESET_XML = "rulesets/pmd/rules.xml";
    private static final String CUSTOM_RULESET_XML = "rulesets/pmd/customrules.xml";
    private static final String DEFAULT_FILTER_XML = "rulesets/pmd/suppressions.properties";
    @Parameter(property="pmd.ruleset")
    protected String pmdRuleset;
    @Parameter(property="pmd.excludeFromFailureFile")
    protected String pmdFilter;
    @Parameter(property="maven.pmd.version", defaultValue="3.15.0")
    private String mavenPmdVersion;
    @Parameter
    private List<Dependency> pmdPlugins = new ArrayList<Dependency>();
    private static final String PMD_VERSION = "6.39.0";
    private static final String PMD_PROPERTIES_FILE = "configuration/pmd.properties";
    private static final String MAVEN_PMD_PLUGIN_ARTIFACT_ID = "maven-pmd-plugin";
    private static final String MAVEN_PMD_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    private static final String MAVEN_PMD_PLUGIN_GOAL = "pmd";

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        Properties userProps = this.loadPropertiesFromFile(PMD_PROPERTIES_FILE);
        String excludeFromFailureLocation = this.getLocation(this.pmdFilter, DEFAULT_FILTER_XML);
        log.debug((CharSequence)("Exclude filter file location is " + excludeFromFailureLocation));
        userProps.setProperty("pmd.excludeFromFailureFile", excludeFromFailureLocation);
        String defaultRulesetLocation = this.getLocation(this.pmdRuleset, DEFAULT_RULESET_XML);
        log.debug((CharSequence)("Default ruleset location is " + defaultRulesetLocation));
        String customRulesetLocation = this.getLocation(this.pmdRuleset, CUSTOM_RULESET_XML);
        log.debug((CharSequence)("Custom ruleset location is " + customRulesetLocation));
        Xpp3Dom configuration = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"targetDirectory", (String)userProps.getProperty("pmd.custom.targetDirectory")), MojoExecutor.element((String)"compileSourceRoots", (String)userProps.getProperty("pmd.custom.compileSourceRoots")), MojoExecutor.element((String)"rulesets", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"ruleset", (String)defaultRulesetLocation), MojoExecutor.element((String)"ruleset", (String)customRulesetLocation)})});
        this.pmdPlugins.add(MojoExecutor.dependency((String)"org.openhab.tools.sat.custom-checks", (String)MAVEN_PMD_PLUGIN_GOAL, (String)this.plugin.getVersion()));
        this.pmdPlugins.add(MojoExecutor.dependency((String)"net.sourceforge.pmd", (String)"pmd-core", (String)PMD_VERSION));
        this.pmdPlugins.add(MojoExecutor.dependency((String)"net.sourceforge.pmd", (String)"pmd-java", (String)PMD_VERSION));
        this.pmdPlugins.add(MojoExecutor.dependency((String)"net.sourceforge.pmd", (String)"pmd-javascript", (String)PMD_VERSION));
        this.pmdPlugins.add(MojoExecutor.dependency((String)"net.sourceforge.pmd", (String)"pmd-jsp", (String)PMD_VERSION));
        this.pmdPlugins.forEach(this.logDependency());
        this.executeCheck(MAVEN_PMD_PLUGIN_GROUP_ID, MAVEN_PMD_PLUGIN_ARTIFACT_ID, this.mavenPmdVersion, MAVEN_PMD_PLUGIN_GOAL, configuration, this.pmdPlugins);
        log.debug((CharSequence)"PMD execution has been finished.");
    }
}

