/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.openhab.tools.analysis.tools.AbstractChecker;
import org.openhab.tools.analysis.tools.internal.SpotBugsVisitors;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="spotbugs", requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class SpotBugsChecker
extends AbstractChecker {
    @Parameter(property="spotbugs.ruleset")
    private String spotbugsRuleset;
    @Parameter(property="spotbugs.include")
    private String spotbugsInclude;
    @Parameter(property="spotbugs.exclude")
    private String spotbugsExclude;
    @Parameter(property="maven.spotbugs.version", defaultValue="4.6.0.0")
    private String spotbugsMavenPluginVersion;
    @Parameter(property="findbugs.slf4j.version", defaultValue="1.5.0")
    private String findBugsSlf4jPluginVersion;
    @Parameter(property="spotbugs.version", defaultValue="4.7.0")
    private String spotBugsVersion;
    @Parameter
    private List<Dependency> spotbugsPlugins = new ArrayList<Dependency>();
    private static final String SPOTBUGS_PROPERTIES_FILE = "configuration/spotbugs.properties";
    private static final String DEFAULT_EXCLUDE_FILTER_XML = "rulesets/spotbugs/exclude.xml";
    private static final String DEFAULT_INCLUDE_FILTER_XML = "rulesets/spotbugs/include.xml";
    private static final String DEFAULT_VISITORS_XML = "rulesets/spotbugs/visitors.xml";
    private static final String SPOTBUGS_PLUGIN_GROUP_ID = "com.github.spotbugs";
    private static final String SPOTBUGS_PLUGIN_ARTIFACT_ID = "spotbugs";
    private static final String SPOTBUGS_MAVEN_PLUGIN_ARTIFACT_ID = "spotbugs-maven-plugin";
    private static final String SPOTBUGS_MAVEN_PLUGIN_GOAL = "spotbugs";
    private static final String SPOTBUGS_INCLUDE_FILTER_USER_PROPERTY = "spotbugs.includeFilterFile";
    private static final String SPOTBUGS_EXCLUDE_FILTER_USER_PROPERTY = "spotbugs.excludeFilterFile";
    private static final String SPOTBUGS_VISITORS_PROPERTY = "spotbugs.visitors";

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        Properties userProps = this.loadPropertiesFromFile(SPOTBUGS_PROPERTIES_FILE);
        String includeLocation = this.getLocation(this.spotbugsInclude, DEFAULT_INCLUDE_FILTER_XML);
        log.debug((CharSequence)("Ruleset location is " + includeLocation));
        userProps.setProperty(SPOTBUGS_INCLUDE_FILTER_USER_PROPERTY, includeLocation);
        String excludeLocation = this.getLocation(this.spotbugsExclude, DEFAULT_EXCLUDE_FILTER_XML);
        log.debug((CharSequence)("Filter location is " + excludeLocation));
        userProps.setProperty(SPOTBUGS_EXCLUDE_FILTER_USER_PROPERTY, excludeLocation);
        String visitors = this.getVisitorsString(this.spotbugsRuleset);
        log.debug((CharSequence)("SpotBugs visitors " + visitors));
        userProps.setProperty(SPOTBUGS_VISITORS_PROPERTY, visitors);
        String outputDir = userProps.getProperty("spotbugs.report.dir");
        this.spotbugsPlugins.add(MojoExecutor.dependency((String)"org.openhab.tools.sat.custom-checks", (String)"findbugs", (String)this.plugin.getVersion()));
        this.spotbugsPlugins.add(MojoExecutor.dependency((String)"jp.skypencil.findbugs.slf4j", (String)"bug-pattern", (String)this.findBugsSlf4jPluginVersion));
        this.spotbugsPlugins.forEach(this.logDependency());
        Xpp3Dom config = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"outputDirectory", (String)outputDir), MojoExecutor.element((String)"xmlOutputDirectory", (String)outputDir), MojoExecutor.element((String)"spotbugsXmlOutputDirectory", (String)outputDir), this.getSpotBugsPlugins(this.spotbugsPlugins)});
        ArrayList<Dependency> spotBugsDeps = new ArrayList<Dependency>();
        spotBugsDeps.add(MojoExecutor.dependency((String)SPOTBUGS_PLUGIN_GROUP_ID, (String)"spotbugs", (String)this.spotBugsVersion));
        spotBugsDeps.forEach(this.logDependency());
        this.executeCheck(SPOTBUGS_PLUGIN_GROUP_ID, SPOTBUGS_MAVEN_PLUGIN_ARTIFACT_ID, this.spotbugsMavenPluginVersion, "spotbugs", config, spotBugsDeps);
        log.debug((CharSequence)"SpotBugs execution has been finished.");
    }

    private MojoExecutor.Element getSpotBugsPlugins(List<Dependency> plugins) {
        LinkedList<MojoExecutor.Element> pluginList = new LinkedList<MojoExecutor.Element>();
        if (plugins != null) {
            for (Dependency artifact : plugins) {
                MojoExecutor.Element element = this.createPlugin(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                pluginList.add(element);
            }
        }
        return new MojoExecutor.Element("plugins", pluginList.toArray(new MojoExecutor.Element[0]));
    }

    private MojoExecutor.Element createPlugin(String groupId, String artifactId, String version) {
        return MojoExecutor.element((String)"plugin", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"groupId", (String)groupId), MojoExecutor.element((String)"artifactId", (String)artifactId), MojoExecutor.element((String)"version", (String)version)});
    }

    private String getVisitorsString(String externalLocation) {
        InputStream stream = null;
        if (externalLocation != null) {
            Path executionDir = Paths.get(this.mavenSession.getExecutionRootDirectory(), new String[0]);
            Path externalDir = Paths.get(externalLocation, new String[0]);
            Path resolvedPath = executionDir.resolve(externalDir);
            File file = resolvedPath.toFile();
            try {
                stream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                this.getLog().warn((CharSequence)("Unable to find file " + resolvedPath.toString()));
            }
        } else {
            stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(DEFAULT_VISITORS_XML);
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SpotBugsVisitors.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            SpotBugsVisitors visitors = (SpotBugsVisitors)unmarshaller.unmarshal(stream);
            return visitors.toString();
        }
        catch (JAXBException e) {
            this.getLog().warn((CharSequence)"Unable to load SpotBugs visitors", (Throwable)e);
            return null;
        }
    }
}

