/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.report;

import java.util.concurrent.locks.ReentrantLock;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.plugin.MojoExecution;

final class ReportUtil {
    static final String SAT_PLUGIN_GROUP_ID = "org.openhab.tools.sat";
    static final String SAT_PLUGIN_ARTIFACT_ID = "sat-plugin";
    static final String SAT_PLUGIN_REPORT_GOAL = "report";
    static final String DIRECTORY_PARAMETER = "summaryReportDirectory";
    static final String HTML_GENERATION_PARAMETER = "summaryHtmlGeneration";
    static final String HTML_GENERATION_PERIOD_PARAMETER = "summaryHtmlGenerationPeriod";
    static final String REPORT_SUBDIR = "report";
    static final String CREATE_HTML_XSLT = "report/create_html.xslt";
    static final String MERGE_XSLT = "report/merge.xslt";
    static final String PREPARE_PMD_XSLT = "report/prepare_pmd.xslt";
    static final String PREPARE_CHECKSTYLE_XSLT = "report/prepare_checkstyle.xslt";
    static final String PREPARE_FINDBUGS_XSLT = "report/prepare_findbugs.xslt";
    static final String SUMMARY_TEMPLATE_FILE_NAME = "summary.html";
    static final String PMD_INPUT_FILE_NAME = "pmd.xml";
    static final String CHECKSTYLE_INPUT_FILE_NAME = "checkstyle-result.xml";
    static final String FINDBUGS_INPUT_FILE_NAME = "spotbugsXml.xml";
    static final String RESULT_FILE_NAME = "report.html";
    static final String SUMMARY_REPORT_FILE_NAME = "summary_report.html";
    static final String SUMMARY_BUNDLES_FILE_NAME = "summary_bundles.html";
    static final String SUMMARY_XML_FILE_NAME = "summary.xml";
    static final String EMPTY = "";
    static final String MERGE_XML_FILE_NAME = "merge.xml";
    static final String MERGE_XML_TMP_FILE_NAME = "merge.xml.tmp";
    private static final ReentrantLock MERGE_LOCK;
    private static final String MERGE_LOCK_KEY_NAME;
    private static final ReentrantLock SUMMARY_LOCK;
    private static final String SUMMARY_LOCK_KEY_NAME;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        MERGE_LOCK_KEY_NAME = String.valueOf(ReportUtil.class.getCanonicalName()) + ".MERGE_LOCK";
        SUMMARY_LOCK_KEY_NAME = String.valueOf(ReportUtil.class.getCanonicalName()) + ".SUMMARY_LOCK";
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        synchronized (classLoader) {
            MERGE_LOCK = ReportUtil.getOrCreateJvmSingletonLock(MERGE_LOCK_KEY_NAME);
            SUMMARY_LOCK = ReportUtil.getOrCreateJvmSingletonLock(SUMMARY_LOCK_KEY_NAME);
        }
    }

    private ReportUtil() {
    }

    private static ReentrantLock getOrCreateJvmSingletonLock(String keyName) {
        ReentrantLock lock = (ReentrantLock)System.getProperties().get(keyName);
        if (lock == null) {
            lock = new ReentrantLock();
            System.getProperties().put(keyName, lock);
        }
        return lock;
    }

    static void acquireMergeLock() {
        MERGE_LOCK.lock();
    }

    static void releaseMergeLock() {
        if (MERGE_LOCK.isHeldByCurrentThread()) {
            MERGE_LOCK.unlock();
        }
    }

    static void acquireSummaryLock() {
        SUMMARY_LOCK.lock();
    }

    static void releaseSummaryLock() {
        if (SUMMARY_LOCK.isHeldByCurrentThread()) {
            SUMMARY_LOCK.unlock();
        }
    }

    static boolean isReportExecution(ExecutionEvent event) {
        MojoExecution execution = event.getMojoExecution();
        return SAT_PLUGIN_GROUP_ID.equals(execution.getGroupId()) && SAT_PLUGIN_ARTIFACT_ID.equals(execution.getArtifactId()) && "report".equals(execution.getGoal());
    }
}

