/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.report;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.dom4j.dom.DOMNodeHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Mojo(name="report")
public class ReportUtility
extends AbstractMojo {
    @Parameter(property="report.targetDir", defaultValue="${project.build.directory}/code-analysis")
    private File targetDirectory;
    @Parameter(property="report.fail.on.error", defaultValue="true")
    private boolean failOnError;
    @Parameter(property="report.summary.targetDir", defaultValue="${session.executionRootDirectory}/target")
    private File summaryReportDirectory;
    private static final String REPORT_SUBDIR = "report";
    @Parameter(property="report.in.maven", defaultValue="true")
    private boolean reportInMaven;
    private static final String CREATE_HTML_XSLT = "report/create_html.xslt";
    private static final String MERGE_XSLT = "report/merge.xslt";
    private static final String PREPARE_PMD_XSLT = "report/prepare_pmd.xslt";
    private static final String PREPARE_CHECKSTYLE_XSLT = "report/prepare_checkstyle.xslt";
    private static final String PREPARE_FINDBUGS_XSLT = "report/prepare_findbugs.xslt";
    private static final String SUMMARY_TEMPLATE_FILE_NAME = "summary.html";
    private static final String PMD_INPUT_FILE_NAME = "pmd.xml";
    private static final String CHECKSTYLE_INPUT_FILE_NAME = "checkstyle-result.xml";
    private static final String FINDBUGS_INPUT_FILE_NAME = "spotbugsXml.xml";
    public static final String RESULT_FILE_NAME = "report.html";
    public static final String SUMMARY_REPORT_FILE_NAME = "summary_report.html";
    public static final String SUMMARY_BUNLES_FILE_NAME = "summary_bundles.html";
    private static final String EMPTY = "";
    private TransformerFactory transformerFactory;

    public void setTargetDirectory(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setSummaryReport(File summaryReport) {
        this.summaryReportDirectory = summaryReport;
    }

    public void setReportInMaven(boolean reportInMaven) {
        this.reportInMaven = reportInMaven;
    }

    public void execute() throws MojoFailureException {
        File inputFilePMD;
        File inputFileCheckstyle;
        this.transformerFactory = TransformerFactory.newInstance(TransformerFactoryImpl.class.getName(), Thread.currentThread().getContextClassLoader());
        String timeStamp = Integer.toHexString((int)System.nanoTime());
        LinkedList<File> transformedReports = new LinkedList<File>();
        File inputFileFindbugs = new File(this.targetDirectory, FINDBUGS_INPUT_FILE_NAME);
        if (inputFileFindbugs.exists()) {
            File findbugsTempFile = new File(this.targetDirectory, timeStamp + "_PostFB.xml");
            this.run(PREPARE_FINDBUGS_XSLT, inputFileFindbugs, findbugsTempFile, EMPTY, null);
            transformedReports.add(findbugsTempFile);
        }
        if ((inputFileCheckstyle = new File(this.targetDirectory, CHECKSTYLE_INPUT_FILE_NAME)).exists()) {
            File checkstyleTempFile = new File(this.targetDirectory, timeStamp + "_PostCS.xml");
            this.run(PREPARE_CHECKSTYLE_XSLT, inputFileCheckstyle, checkstyleTempFile, EMPTY, null);
            transformedReports.add(checkstyleTempFile);
        }
        if ((inputFilePMD = new File(this.targetDirectory, PMD_INPUT_FILE_NAME)).exists()) {
            File pmdTempFile = new File(this.targetDirectory, timeStamp + "_PostPM.xml");
            this.run(PREPARE_PMD_XSLT, inputFilePMD, pmdTempFile, EMPTY, null);
            transformedReports.add(pmdTempFile);
        }
        if (!transformedReports.isEmpty()) {
            while (transformedReports.size() != 1) {
                File firstReport = (File)transformedReports.poll();
                File secondReport = (File)transformedReports.poll();
                File mergeResult = new File(this.targetDirectory, timeStamp + "_" + transformedReports.size() + "_Merge.xml");
                this.run(MERGE_XSLT, firstReport, mergeResult, "with", secondReport);
                transformedReports.add(mergeResult);
                this.deleteFile(firstReport);
                this.deleteFile(secondReport);
            }
            File htmlOutputFileName = new File(this.targetDirectory, RESULT_FILE_NAME);
            File mergedReport = (File)transformedReports.poll();
            this.run(CREATE_HTML_XSLT, mergedReport, htmlOutputFileName, EMPTY, null);
            if (this.summaryReportDirectory != null) {
                this.ensureSummaryReportDirectoryExists();
                this.generateSummaryByBundle(htmlOutputFileName, mergedReport);
                this.generateSummaryByRules(htmlOutputFileName, mergedReport);
            }
            if (this.reportInMaven) {
                this.reportWarningsAndErrors(mergedReport, htmlOutputFileName);
            }
            if (this.failOnError) {
                this.checkForErrors(mergedReport, htmlOutputFileName);
            }
            this.deleteFile(mergedReport);
        } else {
            this.getLog().info((CharSequence)"No reports found !");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String xslt, File input, File output, String param, File value) {
        FileOutputStream outputStream = null;
        try {
            this.getLog().debug((CharSequence)MessageFormat.format("{0}  > {1} {2} {3} >  {4}", input, xslt, param, value, output));
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(xslt);
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StreamSource source = new StreamSource(reader);
            Transformer transformer = this.transformerFactory.newTransformer(source);
            if (!param.isEmpty()) {
                transformer.setParameter(param, value.toURI().toURL());
            }
            outputStream = new FileOutputStream(output);
            StreamResult outputTarget = new StreamResult(outputStream);
            StreamSource xmlSource = new StreamSource(input);
            transformer.transform(xmlSource, outputTarget);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"IOException occcurred ", (Throwable)e);
        }
        catch (TransformerException e) {
            this.getLog().error((CharSequence)"TransformerException occcurred ", (Throwable)e);
        }
        finally {
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)e.getMessage());
                }
            }
        }
    }

    private void deleteFile(File file) {
        if (!file.delete()) {
            this.getLog().error((CharSequence)("Unable to delete file " + file.getAbsolutePath()));
        }
    }

    private void reportWarningsAndErrors(File mergedReport, File reportLocation) {
        NodeList messages = this.selectNodes(mergedReport, "/sca/file/message");
        int messageCount = messages.getLength();
        int errorCount = this.countPriority(messages, "1");
        int warnCount = this.countPriority(messages, "2");
        int infoCount = this.countPriority(messages, "3");
        if (messageCount == 0) {
            return;
        }
        String format = String.format("Code Analysis Tool has found: \n %d error(s)! \n %d warning(s) \n %d info(s)", errorCount, warnCount, infoCount);
        this.report(this.maxLevel(errorCount, warnCount, infoCount), format);
        for (int i = 0; i < messages.getLength(); ++i) {
            Node currentNode = messages.item(i);
            if (currentNode.getNodeType() != 1) continue;
            Element messageNode = (Element)currentNode;
            String priority = messageNode.getAttribute("priority");
            Element fileNode = (Element)messageNode.getParentNode();
            String fileName = fileNode.getAttribute("name");
            String line = messageNode.getAttribute("line");
            String message = messageNode.getAttribute("message").trim();
            String logTemplate = "%s:[%s]\n%s";
            String log = String.format(logTemplate, fileName, line, message);
            this.report(priority, log);
        }
        this.getLog().info((CharSequence)("Detailed report can be found at: file:///" + reportLocation));
    }

    private String maxLevel(int errorCount, int warnCount, int infoCount) {
        if (errorCount > 0) {
            return "1";
        }
        if (warnCount > 0) {
            return "2";
        }
        return "3";
    }

    private int countPriority(NodeList messages, String priority) {
        int count = 0;
        for (int i = 0; i < messages.getLength(); ++i) {
            Element messageNode;
            Node currentNode = messages.item(i);
            if (currentNode.getNodeType() != 1 || !priority.equals((messageNode = (Element)currentNode).getAttribute("priority"))) continue;
            ++count;
        }
        return count;
    }

    private void checkForErrors(File secondMergeResult, File reportLocation) throws MojoFailureException {
        int numberOfErrors = this.selectNodes(secondMergeResult, "/sca/file/message[@priority=1]").getLength();
        if (numberOfErrors > 0) {
            throw new MojoFailureException(String.format("\nCode Analysis Tool has found %d error(s)! \nPlease fix the errors and rerun the build. \n", this.selectNodes(secondMergeResult, "/sca/file/message[@priority=1]").getLength()));
        }
    }

    private void report(String priority, String log) {
        switch (priority) {
            case "1": {
                this.getLog().error((CharSequence)log);
                break;
            }
            case "2": {
                this.getLog().warn((CharSequence)log);
                break;
            }
            default: {
                this.getLog().debug((CharSequence)log);
            }
        }
    }

    private void ensureSummaryReportDirectoryExists() {
        if (!this.summaryReportDirectory.exists()) {
            this.summaryReportDirectory.mkdirs();
        }
    }

    private void generateSummaryByBundle(File htmlOutputFileName, File secondMergeResult) {
        NodeList nodes = this.selectNodes(secondMergeResult, "/sca/file/message");
        int messagesNumber = nodes.getLength();
        if (messagesNumber == 0) {
            this.getLog().info((CharSequence)"Empty report will not be appended to the summary report.");
            return;
        }
        try {
            File summaryReport = new File(this.summaryReportDirectory, SUMMARY_BUNLES_FILE_NAME);
            if (!summaryReport.exists()) {
                InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("report/summary.html");
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)inputStream, (Writer)writer, (Charset)Charset.defaultCharset());
                String htmlString = writer.toString();
                String now = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date());
                htmlString = htmlString.replace("$time", now);
                FileUtils.writeStringToFile((File)summaryReport, (String)htmlString);
            }
            String reportContent = FileUtils.readFileToString((File)summaryReport);
            String singleItem = "<tr class=alternate><td><a href=\"%s\">%s</a></td></tr><tr></tr>";
            Path absoluteIndividualReportPath = htmlOutputFileName.toPath();
            Path summaryReportDirectoryPath = this.summaryReportDirectory.toPath();
            Path relativePath = summaryReportDirectoryPath.relativize(absoluteIndividualReportPath);
            String bundleName = absoluteIndividualReportPath.getName(absoluteIndividualReportPath.getNameCount() - 4).toString();
            String row = String.format("<tr class=alternate><td><a href=\"%s\">%s</a></td></tr><tr></tr>", relativePath, bundleName);
            reportContent = reportContent.replace("<tr></tr>", row);
            FileUtils.writeStringToFile((File)summaryReport, (String)reportContent);
            this.getLog().info((CharSequence)"Individual report appended to summary report.");
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Can't read or write to summary report. The summary report might be incomplete!", (Throwable)e);
        }
    }

    private void generateSummaryByRules(File htmlOutputFileName, File mergedReport) {
        File latestMergeResult = new File(this.summaryReportDirectory, "old_Merge.xml");
        File latestSummaryReport = new File(this.summaryReportDirectory, SUMMARY_REPORT_FILE_NAME);
        try {
            if (!latestMergeResult.exists() && !latestSummaryReport.exists()) {
                latestMergeResult.createNewFile();
                latestSummaryReport.createNewFile();
                Files.copy((File)mergedReport, (File)latestMergeResult);
                Files.copy((File)htmlOutputFileName, (File)latestSummaryReport);
            } else {
                File tempMergedReport = new File(this.summaryReportDirectory, "temp_Merge.xml");
                Files.copy((File)latestMergeResult, (File)tempMergedReport);
                this.run(MERGE_XSLT, tempMergedReport, latestMergeResult, "with", mergedReport);
                this.run(CREATE_HTML_XSLT, latestMergeResult, latestSummaryReport, EMPTY, null);
                this.deleteFile(tempMergedReport);
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Unable to create or write to file " + e.getMessage()), (Throwable)e);
        }
    }

    private NodeList selectNodes(File file, String xPathExpression) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(file);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression expression = xPath.compile(xPathExpression);
            return (NodeList)expression.evaluate(document, XPathConstants.NODESET);
        }
        catch (Exception e) {
            String message = MessageFormat.format("Can't select {0} nodes from {1}. Empty NodeList will be returned.", xPathExpression, file.getAbsolutePath());
            this.getLog().warn((CharSequence)message, (Throwable)e);
            return new DOMNodeHelper.EmptyNodeList();
        }
    }
}

