/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.tools;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public abstract class AbstractChecker
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    @Parameter(defaultValue="${plugin}", readonly=true, required=true)
    protected PluginDescriptor plugin;

    protected Properties loadPropertiesFromFile(String relativePath) throws MojoExecutionException {
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(relativePath);
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException | NullPointerException e) {
            throw new MojoExecutionException("Can't load properties from file " + relativePath, e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Failed to close Input Stream ", (Throwable)e);
            }
        }
        Properties userProps = this.mavenProject.getProperties();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            userProps.setProperty(key, properties.getProperty(key));
        }
        this.getLog().debug((CharSequence)("Properties file " + relativePath + " loaded and properties set."));
        return userProps;
    }

    protected void executeCheck(String groupId, String artifactId, String version, String goal, Xpp3Dom configuration, List<Dependency> dependencies) throws MojoExecutionException {
        Plugin plugin = MojoExecutor.plugin((String)groupId, (String)artifactId, (String)version, dependencies);
        MojoExecutor.executeMojo((Plugin)plugin, (String)goal, (Xpp3Dom)configuration, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
    }

    protected String getLocation(String externalRelativePath, String internalRelativePath) throws MojoExecutionException {
        if (externalRelativePath != null) {
            Path executionDir = Paths.get(this.mavenSession.getExecutionRootDirectory(), new String[0]);
            Path externalDir = Paths.get(externalRelativePath, new String[0]);
            Path resolvedPath = executionDir.resolve(externalDir);
            return resolvedPath.toString();
        }
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(internalRelativePath);
        return url.toString();
    }

    protected Consumer<? super Dependency> logDependency() {
        return d -> this.getLog().info((CharSequence)("Adding dependency to " + d.getArtifactId() + ":" + d.getVersion()));
    }
}

