/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.knn.pq;

import org.openimaj.knn.IntNearestNeighboursExact;
import org.openimaj.knn.pq.IntProductQuantiser;
import org.openimaj.ml.clustering.kmeans.IntKMeans;

public final class IntProductQuantiserUtilities {
    private IntProductQuantiserUtilities() {
    }

    public static IntProductQuantiser train(int[][] data, int numAssigners, int K, int nIter) {
        if (K > 256 || K <= 0) {
            throw new IllegalArgumentException("0 <= K < 256");
        }
        int subDim = data[0].length / numAssigners;
        int[][] tmp = new int[data.length][subDim];
        IntNearestNeighboursExact[] assigners = new IntNearestNeighboursExact[numAssigners];
        IntKMeans kmeans = IntKMeans.createExact(K, 100);
        for (int i = 0; i < numAssigners; ++i) {
            for (int j = 0; j < data.length; ++j) {
                System.arraycopy(data[j], i * subDim, tmp[j], 0, subDim);
            }
            IntKMeans.Result centroids = kmeans.cluster(tmp);
            assigners[i] = (IntNearestNeighboursExact)centroids.getNearestNeighbours();
        }
        return new IntProductQuantiser(assigners);
    }

    public static IntProductQuantiser train(int[][] data, int numAssigners, int nIter) {
        return IntProductQuantiserUtilities.train(data, numAssigners, 256, nIter);
    }
}

