/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.feature.FeatureVector;
import org.openimaj.ml.clustering.ByteCentroidsResult;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.SpatialClusters;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.ml.clustering.assignment.hard.ExactFeatureVectorAssigner;
import org.openimaj.util.pair.IntFloatPair;

public class FeatureVectorCentroidsResult<T extends FeatureVector>
implements SpatialClusters<T>,
CentroidsProvider<T> {
    static final String HEADER = "CLST" + "Byte".charAt(0) + "Cen";
    public T[] centroids;

    public boolean equals(Object obj) {
        if (!(obj instanceof ByteCentroidsResult)) {
            return false;
        }
        FeatureVectorCentroidsResult other = (FeatureVectorCentroidsResult)obj;
        for (int i = 0; i < this.centroids.length; ++i) {
            if (this.centroids[i].equals(other.centroids[i])) continue;
            return false;
        }
        return true;
    }

    public String asciiHeader() {
        return "ASCII" + HEADER;
    }

    public byte[] binaryHeader() {
        return HEADER.getBytes();
    }

    public void readASCII(Scanner br) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void readBinary(DataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeASCII(PrintWriter writer) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeBinary(DataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        String str = "";
        str = str + "ByteCentroidsResult\n";
        str = str + "No. of Clusters: " + this.centroids.length + "\n";
        str = str + "No. of Dimensions: " + this.centroids[0].length() + "\n";
        return str;
    }

    @Override
    public T[] getCentroids() {
        return this.centroids;
    }

    @Override
    public HardAssigner<T, float[], IntFloatPair> defaultHardAssigner() {
        return new ExactFeatureVectorAssigner(this, null);
    }

    @Override
    public int numDimensions() {
        return this.centroids[0].length();
    }

    @Override
    public int numClusters() {
        return this.centroids.length;
    }
}

