/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.soft;

import org.openimaj.feature.DoubleFVComparator;
import org.openimaj.feature.DoubleFVComparison;
import org.openimaj.knn.DoubleNearestNeighbours;
import org.openimaj.knn.DoubleNearestNeighboursExact;
import org.openimaj.knn.DoubleNearestNeighboursProvider;
import org.openimaj.knn.approximate.DoubleNearestNeighboursKDTree;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.SoftAssigner;
import org.openimaj.util.pair.IndependentPair;

public class DoubleKNNAssigner
implements SoftAssigner<double[], double[]> {
    protected DoubleNearestNeighbours nn;
    protected int numNeighbours;

    public DoubleKNNAssigner(CentroidsProvider<double[]> provider, boolean exact, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        if (exact) {
            this.nn = new DoubleNearestNeighboursExact((double[][])provider.getCentroids());
        } else {
            DoubleNearestNeighbours internal;
            if (provider instanceof DoubleNearestNeighboursProvider && (internal = ((DoubleNearestNeighboursProvider)provider).getNearestNeighbours()) != null && internal instanceof DoubleNearestNeighboursKDTree) {
                this.nn = (DoubleNearestNeighboursKDTree)internal;
                return;
            }
            this.nn = new DoubleNearestNeighboursKDTree((double[][])provider.getCentroids(), 8, 768);
        }
    }

    public DoubleKNNAssigner(double[][] data, boolean exact, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        this.nn = exact ? new DoubleNearestNeighboursExact(data) : new DoubleNearestNeighboursKDTree(data, 8, 768);
    }

    public DoubleKNNAssigner(CentroidsProvider<double[]> provider, DoubleFVComparison comparison, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        this.nn = new DoubleNearestNeighboursExact((double[][])provider.getCentroids(), (DoubleFVComparator)comparison);
    }

    public DoubleKNNAssigner(double[][] data, DoubleFVComparison comparison, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        this.nn = new DoubleNearestNeighboursExact(data, (DoubleFVComparator)comparison);
    }

    public int[][] assign(double[][] data) {
        int[][] indices = new int[data.length][this.numNeighbours];
        double[][] distances = new double[data.length][this.numNeighbours];
        this.nn.searchKNN((Object[])data, this.numNeighbours, indices, (Object[])distances);
        return indices;
    }

    @Override
    public int[] assign(double[] data) {
        return this.assign(new double[][]{data})[0];
    }

    public void assignWeighted(double[][] data, int[][] assignments, double[][] weights) {
        this.nn.searchKNN((Object[])data, this.numNeighbours, assignments, (Object[])weights);
    }

    @Override
    public IndependentPair<int[], double[]> assignWeighted(double[] data) {
        int[][] indices = new int[data.length][this.numNeighbours];
        double[][] distances = new double[data.length][this.numNeighbours];
        this.nn.searchKNN((Object[])new double[][]{data}, this.numNeighbours, indices, (Object[])distances);
        return new IndependentPair((Object)indices[0], (Object)distances[0]);
    }

    @Override
    public int numDimensions() {
        return this.nn.numDimensions();
    }

    @Override
    public int size() {
        return this.nn.size();
    }
}

