/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.kmeans;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.openimaj.data.DataSource;
import org.openimaj.data.DoubleArrayBackedDataSource;
import org.openimaj.ml.clustering.IndexClusters;
import org.openimaj.ml.clustering.SpatialClusterer;
import org.openimaj.ml.clustering.kmeans.SphericalKMeansResult;
import org.openimaj.util.function.Operation;
import org.openimaj.util.parallel.Parallel;

public class SphericalKMeans
implements SpatialClusterer<SphericalKMeansResult, double[]> {
    protected final Random rng = new Random();
    protected final boolean damped;
    protected final int maxIters;
    protected final int k;
    protected final double terminationEps = 0.1;
    protected List<Operation<IterationResult>> iterationListeners = new ArrayList<Operation<IterationResult>>(0);

    public SphericalKMeans(int k, int maxIters) {
        this(k, maxIters, true);
    }

    public SphericalKMeans(int k, int maxIters, boolean damped) {
        this.k = k;
        this.maxIters = maxIters;
        this.damped = damped;
    }

    public SphericalKMeans(int k) {
        this(k, 10);
    }

    private void makeRandomCentroid(double[] ds) {
        int i;
        double sumsq = 0.0;
        for (i = 0; i < ds.length; ++i) {
            ds[i] = this.rng.nextGaussian();
            sumsq += ds[i] * ds[i];
        }
        sumsq = 1.0 / Math.sqrt(sumsq);
        i = 0;
        while (i < ds.length) {
            int n = i++;
            ds[n] = ds[n] * sumsq;
        }
    }

    double performIteration(final DataSource<double[]> data, final SphericalKMeansResult result) {
        final int[] clusterSizes = new int[result.centroids.length];
        final double[][] newCentroids = new double[result.centroids.length][result.centroids[0].length];
        final double[] delta = new double[]{0.0};
        Parallel.forRange((int)0, (int)data.size(), (int)1, (Operation)new Operation<Parallel.IntRange>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void perform(Parallel.IntRange range) {
                int i = range.start;
                while (i < range.stop) {
                    double[] vector = (double[])data.getData(i);
                    double assignmentWeight = Double.MIN_VALUE;
                    for (int j = 0; j < result.centroids.length; ++j) {
                        double[] centroid = result.centroids[j];
                        double dp = 0.0;
                        for (int k = 0; k < centroid.length; dp += centroid[k] * vector[k], ++k) {
                        }
                        if (!(dp > assignmentWeight)) continue;
                        assignmentWeight = dp;
                        result.assignments[i] = j;
                    }
                    double[][] dArray = newCentroids;
                    // MONITORENTER : newCentroids
                    int n = result.assignments[i];
                    clusterSizes[n] = clusterSizes[n] + 1;
                    delta[0] = delta[0] + assignmentWeight;
                    for (int k = 0; k < newCentroids[0].length; ++k) {
                        double[] dArray2 = newCentroids[result.assignments[i]];
                        int n2 = k;
                        dArray2[n2] = dArray2[n2] + vector[k];
                    }
                    // MONITOREXIT : dArray
                    ++i;
                }
            }
        });
        Parallel.forRange((int)0, (int)result.centroids.length, (int)1, (Operation)new Operation<Parallel.IntRange>(){

            public void perform(Parallel.IntRange range) {
                for (int j = range.start; j < range.stop; ++j) {
                    int k;
                    if (clusterSizes[j] == 0) {
                        SphericalKMeans.this.makeRandomCentroid(result.centroids[j]);
                        continue;
                    }
                    double[] centroid = result.centroids[j];
                    double[] ncentroid = newCentroids[j];
                    double norm = 0.0;
                    if (SphericalKMeans.this.damped) {
                        for (k = 0; k < centroid.length; ++k) {
                            int n = k;
                            centroid[n] = centroid[n] + ncentroid[k];
                            norm += centroid[k] * centroid[k];
                        }
                    } else {
                        for (k = 0; k < centroid.length; ++k) {
                            centroid[k] = ncentroid[k];
                            norm += centroid[k] * centroid[k];
                        }
                    }
                    norm = 1.0 / Math.sqrt(norm);
                    k = 0;
                    while (k < ncentroid.length) {
                        int n = k++;
                        centroid[n] = centroid[n] * norm;
                    }
                }
            }
        });
        return delta[0];
    }

    public int[][] performClustering(double[][] data) {
        return new IndexClusters(this.cluster((double[][])data).assignments).clusters();
    }

    public SphericalKMeansResult cluster(double[][] data) {
        return this.cluster((DataSource)new DoubleArrayBackedDataSource(data));
    }

    @Override
    public SphericalKMeansResult cluster(DataSource<double[]> data) {
        IterationResult ir = new IterationResult();
        ir.result = new SphericalKMeansResult();
        ir.result.centroids = new double[this.k][data.numDimensions()];
        ir.result.assignments = new int[data.size()];
        for (int j = 0; j < ir.result.centroids.length; ++j) {
            this.makeRandomCentroid(ir.result.centroids[j]);
        }
        double last = 0.0;
        ir.iteration = 0;
        while (ir.iteration < this.maxIters) {
            for (Operation<IterationResult> l : this.iterationListeners) {
                l.perform((Object)ir);
            }
            double d = this.performIteration(data, ir.result);
            ir.delta = d - last;
            if (ir.delta < 0.1) break;
            last = d;
            ++ir.iteration;
        }
        return ir.result;
    }

    public void addIterationListener(Operation<IterationResult> op) {
        this.iterationListeners.add(op);
    }

    public static class IterationResult {
        public int iteration;
        public double delta;
        public SphericalKMeansResult result;
    }
}

