/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.spectral;

import org.openimaj.ml.clustering.SpatialClusterer;
import org.openimaj.ml.clustering.SpatialClusters;
import org.openimaj.ml.clustering.spectral.ChangeDetectingEigenChooser;
import org.openimaj.ml.clustering.spectral.EigenChooser;
import org.openimaj.ml.clustering.spectral.GraphLaplacian;
import org.openimaj.ml.clustering.spectral.HardCodedEigenChooser;
import org.openimaj.util.function.Function;
import org.openimaj.util.pair.IndependentPair;

public class SpectralClusteringConf<DATATYPE> {
    ClustererProvider<DATATYPE> internal;
    public GraphLaplacian laplacian;
    public EigenChooser eigenChooser;
    public int skipEigenVectors = 0;
    public boolean eigenValueScale = false;

    public SpectralClusteringConf(SpatialClusterer<? extends SpatialClusters<DATATYPE>, DATATYPE> internal, int eigK) {
        this.internal = new DefaultClustererFunction<DATATYPE>(internal);
        this.laplacian = new GraphLaplacian.Normalised();
        this.eigenChooser = new HardCodedEigenChooser(eigK);
    }

    public SpectralClusteringConf(SpatialClusterer<? extends SpatialClusters<DATATYPE>, DATATYPE> internal) {
        this.internal = new DefaultClustererFunction<DATATYPE>(internal);
        this.laplacian = new GraphLaplacian.Normalised();
        this.eigenChooser = new ChangeDetectingEigenChooser(100.0, 0.1);
    }

    public SpectralClusteringConf(SpatialClusterer<? extends SpatialClusters<DATATYPE>, DATATYPE> internal, GraphLaplacian lap, int top) {
        this.internal = new DefaultClustererFunction<DATATYPE>(internal);
        this.laplacian = lap;
        this.eigenChooser = new HardCodedEigenChooser(top);
    }

    public SpectralClusteringConf(SpatialClusterer<? extends SpatialClusters<DATATYPE>, DATATYPE> internal, GraphLaplacian laplacian) {
        this.internal = new DefaultClustererFunction<DATATYPE>(internal);
        this.laplacian = laplacian;
        this.eigenChooser = new ChangeDetectingEigenChooser(100.0, 0.1);
    }

    public SpectralClusteringConf(ClustererProvider<DATATYPE> internal) {
        this.internal = internal;
        this.laplacian = new GraphLaplacian.Normalised();
        this.eigenChooser = new ChangeDetectingEigenChooser(100.0, 0.1);
    }

    protected static class DefaultClustererFunction<DATATYPE>
    implements ClustererProvider<DATATYPE> {
        private SpatialClusterer<? extends SpatialClusters<DATATYPE>, DATATYPE> internal;

        public DefaultClustererFunction(SpatialClusterer<? extends SpatialClusters<DATATYPE>, DATATYPE> internal) {
            this.internal = internal;
        }

        public SpatialClusterer<? extends SpatialClusters<DATATYPE>, DATATYPE> apply(IndependentPair<double[], double[][]> in) {
            return this.internal;
        }

        @Override
        public String toString() {
            return this.internal.toString();
        }
    }

    public static interface ClustererProvider<DATATYPE>
    extends Function<IndependentPair<double[], double[][]>, SpatialClusterer<? extends SpatialClusters<DATATYPE>, DATATYPE>> {
        public String toString();
    }
}

