/*
	AUTOMATICALLY GENERATED BY jTemp FROM
	/Users/jsh2/Work/openimaj/target/checkout/machine-learning/clustering/src/main/jtemp/org/openimaj/ml/clustering/assignment/soft/#T#KNNAssigner.jtemp
*/
/**
 * Copyright (c) 2011, The University of Southampton and the individual contributors.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *   * 	Redistributions of source code must retain the above copyright notice,
 * 	this list of conditions and the following disclaimer.
 *
 *   *	Redistributions in binary form must reproduce the above copyright notice,
 * 	this list of conditions and the following disclaimer in the documentation
 * 	and/or other materials provided with the distribution.
 *
 *   *	Neither the name of the University of Southampton nor the names of its
 * 	contributors may be used to endorse or promote products derived from this
 * 	software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.openimaj.ml.clustering.assignment.soft;

import org.openimaj.feature.LongFVComparison;
import org.openimaj.knn.LongNearestNeighbours;
import org.openimaj.knn.LongNearestNeighboursExact;
import org.openimaj.knn.LongNearestNeighboursProvider;
import org.openimaj.knn.approximate.LongNearestNeighboursKDTree;
import org.openimaj.ml.clustering.assignment.SoftAssigner;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.util.pair.IndependentPair;

/**
 * A {@link SoftAssigner} that picks a fixed number of nearest neighbours.
 * Weights returned are actually the distances to the centroids.
 * 
 * @author Jonathon Hare (jsh2@ecs.soton.ac.uk)
 *
 */
public class LongKNNAssigner implements SoftAssigner<long[], double[]> {
	protected LongNearestNeighbours nn;
	protected int numNeighbours;

	/**
	 * Construct the assigner using the given cluster data. The assigner
	 * is backed by either a {@link LongNearestNeighboursExact} or 
	 * {@link LongNearestNeighboursKDTree}, depending on whether the exact
	 * parameter is true or false. If the parameter is true, then the 
	 * resultant {@link LongNearestNeighboursExact} will use Euclidean
	 * distance.
	 * 
	 * @param provider the cluster data provider
	 * @param exact if true, then use exact mode; false implies approximate mode.
	 * @param numNeighbours the number of nearest neighbours to select.
	 */
	public LongKNNAssigner(CentroidsProvider<long[]> provider, boolean exact, int numNeighbours) {
		this.numNeighbours = numNeighbours;
		
		if (exact) {
			nn = new LongNearestNeighboursExact(provider.getCentroids());
		} else {
			if (provider instanceof LongNearestNeighboursProvider) {
				LongNearestNeighbours internal = ((LongNearestNeighboursProvider)provider).getNearestNeighbours();

				if (internal != null && internal instanceof LongNearestNeighboursKDTree) {
					nn = (LongNearestNeighboursKDTree) internal;
					return;
				}
			}

			nn = new LongNearestNeighboursKDTree(provider.getCentroids(), LongNearestNeighboursKDTree.DEFAULT_NTREES, LongNearestNeighboursKDTree.DEFAULT_NCHECKS);
		}
	}
	
	/**
	 * Construct the assigner using the given cluster data. The assigner
	 * is backed by either a {@link LongNearestNeighboursExact} or 
	 * {@link LongNearestNeighboursKDTree}, depending on whether the exact
	 * parameter is true or false. If the parameter is true, then the 
	 * resultant {@link LongNearestNeighboursExact} will use Euclidean
	 * distance.
	 * 
	 * @param data the cluster data
	 * @param exact if true, then use exact mode; false implies approximate mode.
	 * @param numNeighbours the number of nearest neighbours to select.
	 */
	public LongKNNAssigner(long[][] data, boolean exact, int numNeighbours) {
		this.numNeighbours = numNeighbours;
		
		if (exact) {
			nn = new LongNearestNeighboursExact(data);
		} else {
			nn = new LongNearestNeighboursKDTree(data, LongNearestNeighboursKDTree.DEFAULT_NTREES, LongNearestNeighboursKDTree.DEFAULT_NCHECKS);
		}
	}
	
	/**
	 * Construct the assigner using the given cluster data and 
	 * distance function. The assigner will operate in exact mode,
	 * using a {@link LongNearestNeighboursExact}.
	 * 
	 * @param provider the cluster data provider
	 * @param comparison the distance function
	 * @param numNeighbours the number of nearest neighbours to select.
	 */
	public LongKNNAssigner(CentroidsProvider<long[]> provider, LongFVComparison comparison, int numNeighbours) {
		this.numNeighbours = numNeighbours;
		
		nn = new LongNearestNeighboursExact(provider.getCentroids(), comparison);
	}
	
	/**
	 * Construct the assigner using the given cluster data and 
	 * distance function. The assigner will operate in exact mode,
	 * using a {@link LongNearestNeighboursExact}.
	 * 
	 * @param data the cluster data
	 * @param comparison the distance function
	 * @param numNeighbours the number of nearest neighbours to select.
	 */
	public LongKNNAssigner(long[][] data, LongFVComparison comparison, int numNeighbours) {
		this.numNeighbours = numNeighbours;
		
		nn = new LongNearestNeighboursExact(data, comparison);
	}

	@Override
	public int[][] assign(long[][] data) {
		int [][] indices = new int [data.length][numNeighbours];
		double [][] distances = new double [data.length][numNeighbours];
		
		nn.searchKNN(data, numNeighbours, indices, distances);
		
		return indices;
	}

	@Override
	public int[] assign(long[] data) {
		return assign(new long[][] { data })[0];
	}

	@Override
	public void assignWeighted(long[][] data, int[][] assignments, double[][] weights) {
		nn.searchKNN(data, numNeighbours, assignments, weights);
	}

	@Override
	public IndependentPair<int[], double[]> assignWeighted(long[] data) {
		int [][] indices = new int [data.length][numNeighbours];
		double [][] distances = new double [data.length][numNeighbours];
		
		nn.searchKNN(new long[][] { data }, numNeighbours, indices, distances);
		
		return new IndependentPair<int[], double[]>(indices[0], distances[0]);
	}
	
	@Override
	public int numDimensions() {
	    return nn.numDimensions();
	}
	
	@Override
	public int size() {
	    return nn.size();
	}
}
