/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.hard;

import org.openimaj.knn.DoubleNearestNeighbours;
import org.openimaj.knn.DoubleNearestNeighboursProvider;
import org.openimaj.knn.approximate.DoubleNearestNeighboursKDTree;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.util.pair.IntDoublePair;

public class KDTreeDoubleEuclideanAssigner
implements HardAssigner<double[], double[], IntDoublePair> {
    protected DoubleNearestNeighboursKDTree nn;

    public KDTreeDoubleEuclideanAssigner(CentroidsProvider<double[]> provider) {
        DoubleNearestNeighbours internal;
        if (provider instanceof DoubleNearestNeighboursProvider && (internal = ((DoubleNearestNeighboursProvider)provider).getNearestNeighbours()) != null && internal instanceof DoubleNearestNeighboursKDTree) {
            this.nn = (DoubleNearestNeighboursKDTree)internal;
            return;
        }
        this.nn = new DoubleNearestNeighboursKDTree((double[][])provider.getCentroids(), 8, 768);
    }

    public KDTreeDoubleEuclideanAssigner(double[][] data) {
        this.nn = new DoubleNearestNeighboursKDTree(data, 8, 768);
    }

    public int[] assign(double[][] data) {
        int[] argmins = new int[data.length];
        double[] mins = new double[data.length];
        this.nn.searchNN(data, argmins, mins);
        return argmins;
    }

    @Override
    public int assign(double[] data) {
        return this.assign(new double[][]{data})[0];
    }

    public void assignDistance(double[][] data, int[] indices, double[] distances) {
        this.nn.searchNN(data, indices, distances);
    }

    @Override
    public IntDoublePair assignDistance(double[] data) {
        int[] index = new int[1];
        double[] distance = new double[1];
        this.nn.searchNN((double[][])new double[][]{data}, index, distance);
        return new IntDoublePair(index[0], distance[0]);
    }

    @Override
    public int size() {
        return this.nn.size();
    }

    @Override
    public int numDimensions() {
        return this.nn.numDimensions();
    }
}

